/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.statistics;

import com.google.protobuf.ByteString;
import com.whylogs.core.message.NumbersMessage;
import com.whylogs.core.statistics.datatypes.DoubleTracker;
import com.whylogs.core.statistics.datatypes.LongTracker;
import com.whylogs.core.statistics.datatypes.StringTracker;
import com.whylogs.core.statistics.datatypes.VarianceTracker;
import com.whylogs.core.utils.sketches.FrequentStringsSketch;
import com.whylogs.core.utils.sketches.ThetaSketch;
import java.util.Optional;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Union;

public class NumberTracker {
    VarianceTracker variance;
    DoubleTracker doubles;
    LongTracker longs;
    KllFloatsSketch histogram;
    Union thetaSketch;
    ItemsSketch<String> frequentNumbers;

    public NumberTracker() {
        this.variance = new VarianceTracker();
        this.doubles = new DoubleTracker();
        this.longs = new LongTracker();
        this.histogram = new KllFloatsSketch(256);
        this.thetaSketch = Union.builder().buildUnion();
        this.frequentNumbers = new ItemsSketch(128);
    }

    public void track(Number number) {
        double dValue = number.doubleValue();
        this.variance.update(dValue);
        this.histogram.update((float)dValue);
        this.thetaSketch.update(dValue);
        if (this.doubles.getCount() > 0L) {
            this.doubles.update(dValue);
        } else if (number instanceof Long || number instanceof Integer) {
            this.longs.update(number.longValue());
            this.frequentNumbers.update((Object)Long.toString(number.longValue()));
        } else {
            this.doubles.addLongs(this.longs);
            this.longs.reset();
            this.doubles.update(dValue);
            this.frequentNumbers.update((Object)Double.toString(dValue));
        }
    }

    public void add(NumberTracker other) {
        if (other == null) {
            return;
        }
        this.variance.add(other.variance);
        this.doubles.add(other.doubles);
        this.longs.add(other.longs);
        this.histogram.merge(other.histogram);
    }

    public NumberTracker merge(NumberTracker other) {
        if (other == null) {
            return this;
        }
        KllFloatsSketch unionHistogram = KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])this.histogram.toByteArray()));
        unionHistogram.merge(other.histogram);
        Union thetaUnion = Union.builder().buildUnion();
        thetaUnion.update((Sketch)this.thetaSketch.getResult());
        thetaUnion.update((Sketch)other.thetaSketch.getResult());
        ItemsSketch freqNumbers = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])this.frequentNumbers.toByteArray((ArrayOfItemsSerDe)StringTracker.ARRAY_OF_STRINGS_SER_DE)), (ArrayOfItemsSerDe)StringTracker.ARRAY_OF_STRINGS_SER_DE);
        freqNumbers.merge(other.frequentNumbers);
        return NumberTracker.builder().setVariance(this.variance.merge(other.variance)).setDoubles(this.doubles.merge(other.doubles)).setLongs(this.longs.merge(other.longs)).setThetaSketch(thetaUnion).setFrequentNumbers((ItemsSketch<String>)freqNumbers).setHistogram(unionHistogram).build();
    }

    public NumbersMessage.Builder toProtobuf() {
        NumbersMessage.Builder builder = NumbersMessage.newBuilder().setVariance(this.variance.toProtobuf()).setHistogram(ByteString.copyFrom((byte[])this.histogram.toByteArray()));
        if (this.doubles.getCount() > 0L) {
            builder.setDoubles(this.doubles.toProtobuf());
        } else if (this.longs.getCount() > 0L) {
            builder.setLongs(this.longs.toProtobuf());
        }
        builder.setCompactTheta(ThetaSketch.serialize(this.thetaSketch));
        builder.setFrequentNumbers(FrequentStringsSketch.toNumbersMessage(this.frequentNumbers));
        return builder;
    }

    public static NumberTracker fromProtobuf(NumbersMessage message) {
        Memory hMem = Memory.wrap((byte[])message.getHistogram().toByteArray());
        NumberTrackerBuilder builder = NumberTracker.builder().setHistogram(KllFloatsSketch.heapify((Memory)hMem)).setVariance(VarianceTracker.fromProtobuf(message.getVariance()));
        Optional.ofNullable(message.getDoubles()).map(DoubleTracker::fromProtobuf).ifPresent(builder::setDoubles);
        Optional.ofNullable(message.getLongs()).map(LongTracker::fromProtobuf).ifPresent(builder::setLongs);
        builder.setThetaSketch(ThetaSketch.deserialize(message.getCompactTheta()));
        builder.setFrequentNumbers(FrequentStringsSketch.deserialize(message.getFrequentNumbers().getSketch()));
        return builder.build();
    }

    public static NumberTrackerBuilder builder() {
        return new NumberTrackerBuilder();
    }

    public VarianceTracker getVariance() {
        return this.variance;
    }

    public DoubleTracker getDoubles() {
        return this.doubles;
    }

    public LongTracker getLongs() {
        return this.longs;
    }

    public KllFloatsSketch getHistogram() {
        return this.histogram;
    }

    public Union getThetaSketch() {
        return this.thetaSketch;
    }

    public ItemsSketch<String> getFrequentNumbers() {
        return this.frequentNumbers;
    }

    private NumberTracker(VarianceTracker variance, DoubleTracker doubles, LongTracker longs, KllFloatsSketch histogram, Union thetaSketch, ItemsSketch<String> frequentNumbers) {
        this.variance = variance;
        this.doubles = doubles;
        this.longs = longs;
        this.histogram = histogram;
        this.thetaSketch = thetaSketch;
        this.frequentNumbers = frequentNumbers;
    }

    public static class NumberTrackerBuilder {
        private VarianceTracker variance;
        private DoubleTracker doubles;
        private LongTracker longs;
        private KllFloatsSketch histogram;
        private Union thetaSketch;
        private ItemsSketch<String> frequentNumbers;

        NumberTrackerBuilder() {
        }

        public NumberTrackerBuilder setVariance(VarianceTracker variance) {
            this.variance = variance;
            return this;
        }

        public NumberTrackerBuilder setDoubles(DoubleTracker doubles) {
            this.doubles = doubles;
            return this;
        }

        public NumberTrackerBuilder setLongs(LongTracker longs) {
            this.longs = longs;
            return this;
        }

        public NumberTrackerBuilder setHistogram(KllFloatsSketch histogram) {
            this.histogram = histogram;
            return this;
        }

        public NumberTrackerBuilder setThetaSketch(Union thetaSketch) {
            this.thetaSketch = thetaSketch;
            return this;
        }

        public NumberTrackerBuilder setFrequentNumbers(ItemsSketch<String> frequentNumbers) {
            this.frequentNumbers = frequentNumbers;
            return this;
        }

        public NumberTracker build() {
            return new NumberTracker(this.variance, this.doubles, this.longs, this.histogram, this.thetaSketch, this.frequentNumbers);
        }

        public String toString() {
            return "NumberTracker.NumberTrackerBuilder(variance=" + this.variance + ", doubles=" + this.doubles + ", longs=" + this.longs + ", histogram=" + this.histogram + ", thetaSketch=" + this.thetaSketch + ", frequentNumbers=" + this.frequentNumbers + ")";
        }
    }
}

