/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.statistics;

import com.google.common.collect.Maps;
import com.whylogs.core.message.InferredType;
import com.whylogs.core.message.SchemaMessage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SchemaTracker {
    private static final InferredType.Builder UNKNOWN_TYPE_BUILDER = InferredType.newBuilder().setType(InferredType.Type.UNKNOWN);
    private final Map<InferredType.Type, Long> typeCounts;

    public SchemaTracker() {
        this.typeCounts = new HashMap<InferredType.Type, Long>(InferredType.Type.values().length, 1.0f);
    }

    public void track(InferredType.Type type) {
        this.typeCounts.merge(type, 1L, Long::sum);
    }

    long getCount(InferredType.Type type) {
        return this.typeCounts.getOrDefault((Object)type, 0L);
    }

    public Map<InferredType.Type, Long> getTypeCounts() {
        return Collections.unmodifiableMap(this.typeCounts);
    }

    public InferredType getInferredType() {
        long totalCount = this.typeCounts.values().stream().mapToLong(Long::longValue).sum();
        if (totalCount == 0L) {
            return UNKNOWN_TYPE_BUILDER.build();
        }
        InferredType.Builder candidate = this.getMostPopularType(totalCount);
        if (candidate.getRatio() > 0.7) {
            return candidate.build();
        }
        long fractionalCount = Stream.of(InferredType.Type.INTEGRAL, InferredType.Type.FRACTIONAL).mapToLong(type -> this.typeCounts.getOrDefault(type, 0L)).sum();
        InferredType.Type candidateType = candidate.getType();
        if (candidateType == InferredType.Type.STRING && this.typeCounts.get((Object)InferredType.Type.STRING) > fractionalCount) {
            long coercedCount = Stream.of(InferredType.Type.STRING, InferredType.Type.INTEGRAL, InferredType.Type.FRACTIONAL, InferredType.Type.BOOLEAN).mapToLong(type -> this.typeCounts.getOrDefault(type, 0L)).sum();
            double actualRatio = (double)coercedCount / (double)totalCount;
            return InferredType.newBuilder().setType(InferredType.Type.STRING).setRatio(actualRatio).build();
        }
        if (candidate.getRatio() > 0.5) {
            long actualCount = this.typeCounts.get((Object)candidateType);
            if (candidateType == InferredType.Type.FRACTIONAL) {
                actualCount = fractionalCount;
            }
            return InferredType.newBuilder().setType(candidateType).setRatio((double)actualCount / (double)totalCount).build();
        }
        double fractionalRatio = (double)fractionalCount / (double)totalCount;
        if (fractionalRatio > 0.5) {
            return InferredType.newBuilder().setType(InferredType.Type.FRACTIONAL).setRatio(fractionalRatio).build();
        }
        return InferredType.newBuilder().setType(InferredType.Type.UNKNOWN).setRatio(1.0).build();
    }

    public SchemaMessage.Builder toProtobuf() {
        Map<Integer, Long> protobufFriendlyMap = this.typeCounts.entrySet().stream().collect(Collectors.toMap(e -> ((InferredType.Type)((Object)((Object)e.getKey()))).getNumber(), Map.Entry::getValue));
        return SchemaMessage.newBuilder().putAllTypeCounts(protobufFriendlyMap);
    }

    public static SchemaTracker fromProtobuf(SchemaMessage message) {
        SchemaTracker schemaTracker = new SchemaTracker();
        message.getTypeCountsMap().forEach((k, v) -> schemaTracker.typeCounts.put(InferredType.Type.forNumber(k), (Long)v));
        return schemaTracker;
    }

    private InferredType.Builder getMostPopularType(long totalCount) {
        InferredType.Type mostPopularType = this.typeCounts.entrySet().stream().max((e1, e2) -> (int)((Long)e1.getValue() - (Long)e2.getValue())).map(Map.Entry::getKey).orElse(InferredType.Type.UNKNOWN);
        Long count = this.typeCounts.getOrDefault((Object)mostPopularType, 0L);
        double ratio = (double)count.longValue() * 1.0 / (double)totalCount;
        return InferredType.newBuilder().setType(mostPopularType).setRatio(ratio);
    }

    public void add(SchemaTracker other) {
        InferredType.Type[] allTypes;
        for (InferredType.Type type : allTypes = InferredType.Type.values()) {
            if (!this.typeCounts.containsKey((Object)type) && !other.typeCounts.containsKey((Object)type)) continue;
            this.typeCounts.merge(type, other.getCount(type), Long::sum);
        }
    }

    public SchemaTracker merge(SchemaTracker other) {
        InferredType.Type[] allTypes;
        SchemaTracker thisCopy = new SchemaTracker(Maps.newHashMap(this.typeCounts));
        for (InferredType.Type type : allTypes = InferredType.Type.values()) {
            if (!this.typeCounts.containsKey((Object)type) && !other.typeCounts.containsKey((Object)type)) continue;
            thisCopy.typeCounts.merge(type, other.getCount(type), Long::sum);
        }
        return thisCopy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaTracker)) {
            return false;
        }
        SchemaTracker other = (SchemaTracker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<InferredType.Type, Long> this$typeCounts = this.getTypeCounts();
        Map<InferredType.Type, Long> other$typeCounts = other.getTypeCounts();
        return !(this$typeCounts == null ? other$typeCounts != null : !((Object)this$typeCounts).equals(other$typeCounts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchemaTracker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<InferredType.Type, Long> $typeCounts = this.getTypeCounts();
        result = result * 59 + ($typeCounts == null ? 43 : ((Object)$typeCounts).hashCode());
        return result;
    }

    public SchemaTracker(Map<InferredType.Type, Long> typeCounts) {
        this.typeCounts = typeCounts;
    }
}

