/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.statistics.datatypes;

import com.google.protobuf.ByteString;
import com.whylogs.core.message.StringsMessage;
import com.whylogs.core.utils.sketches.ThetaSketch;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Union;

public final class StringTracker {
    public static final ArrayOfStringsSerDe ARRAY_OF_STRINGS_SER_DE = new ArrayOfStringsSerDe();
    public static final int MAX_FREQUENT_ITEM_SIZE = 128;
    private long count;
    private final ItemsSketch<String> items;
    private final Union thetaSketch;

    public StringTracker() {
        this.count = 0L;
        this.items = new ItemsSketch(128);
        this.thetaSketch = Union.builder().buildUnion();
    }

    public void update(String value) {
        if (value == null) {
            return;
        }
        ++this.count;
        this.thetaSketch.update(value);
        this.items.update((Object)value);
    }

    public StringTracker merge(StringTracker other) {
        byte[] bytes = this.items.toByteArray((ArrayOfItemsSerDe)ARRAY_OF_STRINGS_SER_DE);
        ItemsSketch itemsCopy = ItemsSketch.getInstance((Memory)WritableMemory.wrap((byte[])bytes), (ArrayOfItemsSerDe)ARRAY_OF_STRINGS_SER_DE);
        itemsCopy.merge(other.items);
        Union thetaUnion = Union.builder().buildUnion();
        thetaUnion.update((Sketch)this.thetaSketch.getResult());
        thetaUnion.update((Sketch)other.thetaSketch.getResult());
        return new StringTracker(this.count + other.count, (ItemsSketch<String>)itemsCopy, thetaUnion);
    }

    public StringsMessage.Builder toProtobuf() {
        return StringsMessage.newBuilder().setCount(this.count).setItems(ByteString.copyFrom((byte[])this.items.toByteArray((ArrayOfItemsSerDe)ARRAY_OF_STRINGS_SER_DE))).setCompactTheta(ThetaSketch.serialize(this.thetaSketch));
    }

    public static StringTracker fromProtobuf(StringsMessage message) {
        Memory iMem = Memory.wrap((byte[])message.getItems().toByteArray());
        ItemsSketch items = ItemsSketch.getInstance((Memory)iMem, (ArrayOfItemsSerDe)ARRAY_OF_STRINGS_SER_DE);
        return StringTracker.builder().count(message.getCount()).items((ItemsSketch<String>)items).thetaSketch(ThetaSketch.deserialize(message.getCompactTheta())).build();
    }

    public static StringTrackerBuilder builder() {
        return new StringTrackerBuilder();
    }

    public long getCount() {
        return this.count;
    }

    public ItemsSketch<String> getItems() {
        return this.items;
    }

    public Union getThetaSketch() {
        return this.thetaSketch;
    }

    private StringTracker(long count, ItemsSketch<String> items, Union thetaSketch) {
        this.count = count;
        this.items = items;
        this.thetaSketch = thetaSketch;
    }

    public static class StringTrackerBuilder {
        private long count;
        private ItemsSketch<String> items;
        private Union thetaSketch;

        StringTrackerBuilder() {
        }

        public StringTrackerBuilder count(long count) {
            this.count = count;
            return this;
        }

        public StringTrackerBuilder items(ItemsSketch<String> items) {
            this.items = items;
            return this;
        }

        public StringTrackerBuilder thetaSketch(Union thetaSketch) {
            this.thetaSketch = thetaSketch;
            return this;
        }

        public StringTracker build() {
            return new StringTracker(this.count, this.items, this.thetaSketch);
        }

        public String toString() {
            return "StringTracker.StringTrackerBuilder(count=" + this.count + ", items=" + this.items + ", thetaSketch=" + this.thetaSketch + ")";
        }
    }
}

