/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.statistics.datatypes;

import com.whylogs.core.message.VarianceMessage;

public class VarianceTracker {
    long count = 0L;
    double sum = 0.0;
    double mean = 0.0;

    public void update(double newValue) {
        ++this.count;
        double delta = newValue - this.mean;
        this.mean += delta / (double)this.count;
        double delta2 = newValue - this.mean;
        this.sum += delta * delta2;
    }

    public double stddev() {
        return Math.sqrt(this.variance());
    }

    public double variance() {
        if (this.count < 2L) {
            return Double.NaN;
        }
        return this.sum / ((double)this.count - 1.0);
    }

    public void add(VarianceTracker other) {
        if (other == null || other.count == 0L) {
            return;
        }
        if (this.count == 0L) {
            this.count = other.count;
            this.mean = other.mean;
            this.sum = other.sum;
            return;
        }
        double delta = this.mean - other.mean;
        long totalCount = this.count + other.count;
        this.sum += other.sum + Math.pow(delta, 2.0) * (double)this.count * (double)other.count / (double)totalCount;
        double thisRatio = (double)this.count / (double)totalCount;
        double otherRatio = 1.0 - thisRatio;
        this.mean = this.mean * thisRatio + other.mean * otherRatio;
        this.count += other.count;
    }

    public VarianceTracker merge(VarianceTracker other) {
        VarianceTracker thisCopy = this.copy();
        thisCopy.add(other);
        return thisCopy;
    }

    VarianceTracker copy() {
        VarianceTracker result = new VarianceTracker();
        result.count = this.count;
        result.sum = this.sum;
        result.mean = this.mean;
        return result;
    }

    public VarianceMessage.Builder toProtobuf() {
        return VarianceMessage.newBuilder().setCount(this.count).setMean(this.mean).setSum(this.sum);
    }

    public static VarianceTracker fromProtobuf(VarianceMessage message) {
        VarianceTracker tracker = new VarianceTracker();
        tracker.count = message.getCount();
        tracker.mean = message.getMean();
        tracker.sum = message.getSum();
        return tracker;
    }

    public long getCount() {
        return this.count;
    }

    public double getSum() {
        return this.sum;
    }

    public double getMean() {
        return this.mean;
    }
}

