/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core;

import com.google.common.collect.Sets;
import com.whylogs.core.message.ModelProfileMessage;
import com.whylogs.core.metrics.ModelMetrics;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ModelProfile {
    private final Set<String> outputFields;
    private final ModelMetrics metrics;

    public ModelProfile(String prediction, String target, String score, Iterable<String> additionalOutputFields) {
        this.outputFields = Sets.newHashSet(additionalOutputFields);
        this.outputFields.add(prediction);
        this.metrics = new ModelMetrics(prediction, target, score);
    }

    public ModelProfile(String prediction, String target, Iterable<String> additionalOutputFields) {
        this.outputFields = Sets.newHashSet(additionalOutputFields);
        this.outputFields.add(prediction);
        this.metrics = new ModelMetrics(prediction, target);
    }

    public ModelProfileMessage.Builder toProtobuf() {
        ModelProfileMessage.Builder builder = ModelProfileMessage.newBuilder();
        builder.addAllOutputFields(this.outputFields);
        if (this.metrics != null) {
            builder.setMetrics(this.metrics.toProtobuf());
        }
        return builder;
    }

    public static ModelProfile fromProtobuf(ModelProfileMessage message) {
        if (message == null || message.getSerializedSize() == 0) {
            return null;
        }
        ModelMetrics metrics = ModelMetrics.fromProtobuf(message.getMetrics());
        HashSet outputFields = Sets.newHashSet((Iterable)message.getOutputFieldsList());
        return new ModelProfile(outputFields, metrics);
    }

    public ModelProfile merge(ModelProfile other) {
        if (other == null) {
            return new ModelProfile(Sets.newHashSet(this.outputFields), this.metrics.copy());
        }
        return new ModelProfile(Sets.newHashSet(this.outputFields), this.metrics.merge(other.metrics));
    }

    public ModelProfile copy() {
        return this.merge(null);
    }

    public void track(Map<String, ?> columns) {
        this.metrics.track(columns);
    }

    private ModelProfile(Set<String> outputFields, ModelMetrics metrics) {
        this.outputFields = outputFields;
        this.metrics = metrics;
    }

    public ModelMetrics getMetrics() {
        return this.metrics;
    }
}

