/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core;

import com.google.protobuf.GeneratedMessageV3;
import com.whylogs.core.message.DoublesMessage;
import com.whylogs.core.message.FrequentNumbersSummary;
import com.whylogs.core.message.FrequentStringsSummary;
import com.whylogs.core.message.HistogramSummary;
import com.whylogs.core.message.InferredType;
import com.whylogs.core.message.NumberSummary;
import com.whylogs.core.message.QuantileSummary;
import com.whylogs.core.message.SchemaSummary;
import com.whylogs.core.message.StringsSummary;
import com.whylogs.core.message.UniqueCountSummary;
import com.whylogs.core.statistics.NumberTracker;
import com.whylogs.core.statistics.SchemaTracker;
import com.whylogs.core.statistics.datatypes.StringTracker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.datasketches.frequencies.ErrorType;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Union;

public class SummaryConverters {
    public static UniqueCountSummary fromSketch(Union sketch) {
        CompactSketch result = sketch.getResult();
        return UniqueCountSummary.newBuilder().setEstimate(result.getEstimate()).setUpper(result.getUpperBound(1)).setLower(result.getLowerBound(1)).build();
    }

    public static StringsSummary fromStringTracker(StringTracker tracker) {
        FrequentStringsSummary frequentStrings;
        if (tracker == null) {
            return null;
        }
        if (tracker.getCount() == 0L) {
            return null;
        }
        UniqueCountSummary uniqueCount = SummaryConverters.fromSketch(tracker.getThetaSketch());
        StringsSummary.Builder builder = StringsSummary.newBuilder().setUniqueCount(uniqueCount).setLength(SummaryConverters.fromNumberTracker(tracker.getLength())).setTokenLength(SummaryConverters.fromNumberTracker(tracker.getTokenLength())).setCharPosTracker(tracker.getCharPosTracker().toSummary());
        if (uniqueCount.getEstimate() < 100.0 && (frequentStrings = SummaryConverters.fromStringSketch(tracker.getItems())) != null) {
            builder.setFrequent(frequentStrings);
        }
        return builder.build();
    }

    public static SchemaSummary.Builder fromSchemaTracker(SchemaTracker tracker) {
        Map<InferredType.Type, Long> typeCounts = tracker.getTypeCounts();
        Map<String, Long> typeCountWithNames = typeCounts.entrySet().stream().collect(Collectors.toMap(e -> ((InferredType.Type)((Object)((Object)e.getKey()))).name(), Map.Entry::getValue));
        return SchemaSummary.newBuilder().setInferredType(tracker.getInferredType()).putAllTypeCounts(typeCountWithNames);
    }

    public static NumberSummary fromNumberTracker(NumberTracker numberTracker) {
        double max;
        double min;
        double mean;
        if (numberTracker == null) {
            return null;
        }
        long count = numberTracker.getVariance().getCount();
        if (count == 0L) {
            return null;
        }
        double stddev = numberTracker.getVariance().stddev();
        DoublesMessage.Builder doubles = numberTracker.getDoubles().toProtobuf();
        if (doubles.getCount() > 0L) {
            mean = doubles.getSum() / (double)doubles.getCount();
            min = doubles.getMin();
            max = doubles.getMax();
        } else {
            mean = numberTracker.getLongs().getMean();
            min = numberTracker.getLongs().getMin();
            max = numberTracker.getLongs().getMax();
        }
        HistogramSummary histogram = SummaryConverters.fromUpdateDoublesSketch(numberTracker.getHistogram());
        ItemsSketch.Row[] items = numberTracker.getFrequentNumbers().getFrequentItems(0L, ErrorType.NO_FALSE_NEGATIVES);
        FrequentNumbersSummary.Builder frequentNumbers = FrequentNumbersSummary.newBuilder();
        for (int i = 0; i < items.length; ++i) {
            GeneratedMessageV3 value;
            ItemsSketch.Row item = items[i];
            String content = (String)item.getItem();
            if (content.contains(".")) {
                value = FrequentNumbersSummary.FrequentDoubleItem.newBuilder().setValue(Double.parseDouble(content)).setEstimate(item.getEstimate()).setRank(i).build();
                frequentNumbers.addDoubles((FrequentNumbersSummary.FrequentDoubleItem)value);
                continue;
            }
            value = FrequentNumbersSummary.FrequentLongItem.newBuilder().setValue(Long.parseLong(content)).setEstimate(item.getEstimate()).setRank(i).build();
            frequentNumbers.addLongs((FrequentNumbersSummary.FrequentLongItem)value);
        }
        CompactSketch result = numberTracker.getThetaSketch().getResult();
        UniqueCountSummary.Builder uniqueCountSummary = UniqueCountSummary.newBuilder().setEstimate(result.getEstimate()).setLower(result.getLowerBound(1)).setUpper(result.getUpperBound(1));
        double[] QUANTILES = new double[]{0.0, 0.01, 0.05, 0.25, 0.5, 0.75, 0.95, 0.99, 1.0};
        Double[] boxedQuantiles = ArrayUtils.toObject((double[])QUANTILES);
        float[] qvals = numberTracker.getHistogram().getQuantiles(QUANTILES);
        int len = qvals.length;
        Double[] boxedQvals = new Double[len];
        for (int index = 0; index < qvals.length; ++index) {
            boxedQvals[index] = qvals[index];
        }
        QuantileSummary.Builder quantileSummary = QuantileSummary.newBuilder().addAllQuantiles(Arrays.asList(boxedQuantiles)).addAllQuantileValues(Arrays.asList(boxedQvals));
        return NumberSummary.newBuilder().setCount(count).setStddev(stddev).setMin(min).setMax(max).setMean(mean).setHistogram(histogram).setFrequentNumbers(frequentNumbers).setUniqueCount(uniqueCountSummary).setQuantiles(quantileSummary).setIsDiscrete(false).build();
    }

    public static FrequentStringsSummary fromStringSketch(ItemsSketch<String> sketch) {
        ItemsSketch.Row[] frequentItems = sketch.getFrequentItems(ErrorType.NO_FALSE_NEGATIVES);
        if (frequentItems.length == 0) {
            return null;
        }
        List result = Stream.of(frequentItems).map(SummaryConverters::toFrequentItem).collect(Collectors.toList());
        return FrequentStringsSummary.newBuilder().addAllItems(result).build();
    }

    private static FrequentStringsSummary.FrequentItem toFrequentItem(ItemsSketch.Row<String> row) {
        return FrequentStringsSummary.FrequentItem.newBuilder().setValue((String)row.getItem()).setEstimate(row.getEstimate()).build();
    }

    public static HistogramSummary fromUpdateDoublesSketch(KllFloatsSketch sketch) {
        long n = sketch.getN();
        float start = sketch.getMinValue();
        float end = sketch.getMaxValue();
        HistogramSummary.Builder builder = HistogramSummary.newBuilder().setStart(start).setEnd(end);
        if (n < 2L || start == end) {
            ArrayList<Long> longs = new ArrayList<Long>();
            int i = 0;
            while ((long)i < n) {
                longs.add(0L);
                ++i;
            }
            return builder.setWidth(0.0).addAllCounts(longs).build();
        }
        int numberOfBuckets = (int)Math.min(Math.ceil((double)n / 4.0), 100.0);
        float width = (end - start) / ((float)numberOfBuckets * 1.0f);
        builder.setWidth(width);
        float[] splitPoints = new float[numberOfBuckets];
        for (int i = 0; i < numberOfBuckets; ++i) {
            splitPoints[i] = start + (float)i * width;
        }
        double[] pmf = sketch.getPMF(splitPoints);
        int len = pmf.length - 1;
        for (int i = 0; i < len; ++i) {
            builder.addCounts(Math.round(pmf[i] * (double)sketch.getN()));
        }
        return builder.build();
    }
}

