/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.metrics;

import com.google.common.base.Preconditions;
import com.whylogs.core.message.ModelMetricsMessage;
import com.whylogs.core.message.ModelType;
import com.whylogs.core.metrics.RegressionMetrics;
import com.whylogs.core.metrics.ScoreMatrix;
import java.util.Map;

public class ModelMetrics {
    private final ModelType modelType;
    private final ScoreMatrix scoreMatrix;
    private final RegressionMetrics regressionMetrics;

    public ModelMetrics(String predictionField, String targetField, String scoreField) {
        this(ModelType.CLASSIFICATION, new ScoreMatrix(predictionField, targetField, scoreField), null);
    }

    public ModelMetrics(String predictionField, String targetField) {
        this(ModelType.REGRESSION, null, new RegressionMetrics(predictionField, targetField));
    }

    public void track(Map<String, ?> columns) {
        switch (this.modelType) {
            case CLASSIFICATION: {
                this.scoreMatrix.track(columns);
                break;
            }
            case REGRESSION: {
                this.regressionMetrics.track(columns);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported model type: " + (Object)((Object)this.modelType));
            }
        }
    }

    public ModelMetricsMessage.Builder toProtobuf() {
        ModelMetricsMessage.Builder res = ModelMetricsMessage.newBuilder().setModelType(this.modelType);
        if (this.scoreMatrix != null) {
            res.setScoreMatrix(this.scoreMatrix.toProtobuf());
        }
        if (this.regressionMetrics != null) {
            res.setRegressionMetrics(this.regressionMetrics.toProtobuf());
        }
        return res;
    }

    public ModelMetrics merge(ModelMetrics other) {
        if (other == null) {
            return this;
        }
        Preconditions.checkArgument((this.modelType == other.modelType ? 1 : 0) != 0, (String)"Mismatched model type: expected %s, got %s", (Object[])new Object[]{this.modelType, other.modelType});
        switch (this.modelType) {
            case CLASSIFICATION: {
                ScoreMatrix mergedMatrix = this.scoreMatrix.merge(other.scoreMatrix);
                return new ModelMetrics(this.modelType, mergedMatrix, null);
            }
            case REGRESSION: {
                RegressionMetrics mergedRegressionMetrics = this.regressionMetrics.merge(other.regressionMetrics);
                return new ModelMetrics(this.modelType, null, mergedRegressionMetrics);
            }
        }
        throw new IllegalArgumentException("Unsupported model type: " + (Object)((Object)this.modelType));
    }

    public ModelMetrics copy() {
        switch (this.modelType) {
            case CLASSIFICATION: {
                return new ModelMetrics(this.modelType, this.scoreMatrix.copy(), null);
            }
            case REGRESSION: {
                return new ModelMetrics(this.modelType, null, this.regressionMetrics.copy());
            }
        }
        throw new IllegalArgumentException("Unsupported model type: " + (Object)((Object)this.modelType));
    }

    public static ModelMetrics fromProtobuf(ModelMetricsMessage msg) {
        if (msg == null || msg.getSerializedSize() == 0) {
            return null;
        }
        ScoreMatrix scoreMatrix = ScoreMatrix.fromProtobuf(msg.getScoreMatrix());
        RegressionMetrics regressionMetrics = RegressionMetrics.fromProtobuf(msg.getRegressionMetrics());
        return new ModelMetrics(msg.getModelType(), scoreMatrix, regressionMetrics);
    }

    private ModelMetrics(ModelType modelType, ScoreMatrix scoreMatrix, RegressionMetrics regressionMetrics) {
        this.modelType = modelType;
        this.scoreMatrix = scoreMatrix;
        this.regressionMetrics = regressionMetrics;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public ScoreMatrix getScoreMatrix() {
        return this.scoreMatrix;
    }

    public RegressionMetrics getRegressionMetrics() {
        return this.regressionMetrics;
    }
}

