/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.metrics;

import com.google.common.base.Preconditions;
import com.whylogs.core.message.RegressionMetricsMessage;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegressionMetrics {
    private static final Logger log = LoggerFactory.getLogger(RegressionMetrics.class);
    private final String predictionField;
    private final String targetField;
    private double sumAbsDiff;
    private double sumDiff;
    private double sum2Diff;
    private long count;

    public void track(Map<String, ?> columns) {
        Preconditions.checkState((this.predictionField != null ? 1 : 0) != 0);
        Preconditions.checkState((this.targetField != null ? 1 : 0) != 0);
        Number prediction = (Number)columns.get(this.predictionField);
        Number target = (Number)columns.get(this.targetField);
        double diff = prediction.doubleValue() - target.doubleValue();
        this.sumAbsDiff += Math.abs(diff);
        this.sumDiff += diff;
        this.sum2Diff += diff * diff;
        ++this.count;
    }

    public RegressionMetrics copy() {
        RegressionMetrics res = new RegressionMetrics(this.predictionField, this.targetField);
        res.sumAbsDiff = this.sumAbsDiff;
        res.sumDiff = this.sumDiff;
        res.sum2Diff = this.sum2Diff;
        return res;
    }

    public RegressionMetrics merge(RegressionMetrics other) {
        if (other == null) {
            return this.copy();
        }
        Preconditions.checkState((boolean)Objects.equals(this.predictionField, other.predictionField), (String)"Mismatched prediction fields: %s vs %s", (Object[])new Object[]{this.predictionField, other.predictionField});
        Preconditions.checkState((boolean)Objects.equals(this.targetField, other.targetField), (String)"Mismatched target fields: %s vs %s", (Object[])new Object[]{this.targetField, other.targetField});
        RegressionMetrics result = new RegressionMetrics(this.predictionField, this.targetField);
        result.sumAbsDiff = this.sumAbsDiff + other.sumAbsDiff;
        result.sumDiff = this.sumDiff + other.sumDiff;
        result.sum2Diff = this.sum2Diff + other.sum2Diff;
        result.count = this.count + other.count;
        return result;
    }

    public RegressionMetricsMessage.Builder toProtobuf() {
        if (this.predictionField == null | this.targetField == null) {
            return null;
        }
        return RegressionMetricsMessage.newBuilder().setPredictionField(this.predictionField).setTargetField(this.targetField).setSumAbsDiff(this.sumAbsDiff).setSumDiff(this.sumDiff).setSum2Diff(this.sum2Diff).setCount(this.count);
    }

    public static RegressionMetrics fromProtobuf(RegressionMetricsMessage msg) {
        if (msg == null) {
            return null;
        }
        if ("".equals(msg.getPredictionField()) || "".equals(msg.getTargetField())) {
            log.warn("Skipping Regression metrics: prediction or target field not set");
            return null;
        }
        RegressionMetrics res = new RegressionMetrics(msg.getPredictionField(), msg.getTargetField());
        res.sumAbsDiff = msg.getSumAbsDiff();
        res.sumDiff = msg.getSumDiff();
        res.sum2Diff = msg.getSum2Diff();
        res.count = msg.getCount();
        return res;
    }

    public RegressionMetrics(String predictionField, String targetField) {
        this.predictionField = predictionField;
        this.targetField = targetField;
    }

    public String getPredictionField() {
        return this.predictionField;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public double getSumAbsDiff() {
        return this.sumAbsDiff;
    }

    public double getSumDiff() {
        return this.sumDiff;
    }

    public double getSum2Diff() {
        return this.sum2Diff;
    }

    public long getCount() {
        return this.count;
    }
}

