/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.statistics.datatypes;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.whylogs.core.SummaryConverters;
import com.whylogs.core.message.CharPosMessage;
import com.whylogs.core.message.CharPosSummary;
import com.whylogs.core.message.NumbersMessage;
import com.whylogs.core.statistics.NumberTracker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharPosTracker {
    private static final Logger log = LoggerFactory.getLogger(CharPosTracker.class);
    private Set<Character> characterList;
    private final Map<Character, NumberTracker> charPosMap;

    CharPosTracker(Set<Character> characterList) {
        this.characterList = characterList;
        this.charPosMap = Maps.newHashMap();
    }

    CharPosTracker(String charString, Map<Character, NumberTracker> charPosMap) {
        this.characterList = charString.chars().mapToObj(chr -> Character.valueOf((char)chr)).collect(Collectors.toSet());
        this.charPosMap = charPosMap;
    }

    CharPosTracker(String charString) {
        this(charString.chars().mapToObj(chr -> Character.valueOf((char)chr)).collect(Collectors.toSet()));
    }

    CharPosTracker() {
        this("abcdefghijklmnopqrstuvwzyz0123456789-@!#$%^&*()[]{}");
    }

    private void update(int idx, char c) {
        if (this.characterList != null && this.characterList.contains(Character.valueOf(c))) {
            if (!this.charPosMap.containsKey(Character.valueOf(c))) {
                this.charPosMap.put(Character.valueOf(c), new NumberTracker());
            }
            this.charPosMap.get(Character.valueOf(c)).track(idx);
        } else {
            if (!this.charPosMap.containsKey(Character.valueOf('\u0000'))) {
                this.charPosMap.put(Character.valueOf('\u0000'), new NumberTracker());
            }
            this.charPosMap.get(Character.valueOf('\u0000')).track(idx);
        }
    }

    private void update(int idx, int codePoint) {
        char[] chars = Character.toChars(codePoint);
        if (chars.length == 1) {
            this.update(idx, Character.toLowerCase(chars[0]));
        } else {
            if (!this.charPosMap.containsKey(Character.valueOf('\u0000'))) {
                this.charPosMap.put(Character.valueOf('\u0000'), new NumberTracker());
            }
            this.charPosMap.get(Character.valueOf('\u0000')).track(idx);
        }
    }

    public void update(String value) {
        int[] cp = value.codePoints().toArray();
        for (int i = 0; i < cp.length; ++i) {
            this.update(i, cp[i]);
        }
    }

    public void update(String value, String charString) {
        Set newSet;
        if (charString != null && !this.characterList.equals(newSet = charString.chars().mapToObj(chr -> Character.valueOf((char)chr)).collect(Collectors.toSet()))) {
            if (!this.charPosMap.isEmpty()) {
                log.warn("Changing character list, a non-empty character position tracker is being reset to remove ambiguities");
            }
            this.characterList = newSet;
            this.charPosMap.clear();
        }
        int[] cp = value.codePoints().toArray();
        for (int i = 0; i < cp.length; ++i) {
            this.update(i, cp[i]);
        }
    }

    public CharPosTracker merge(CharPosTracker other) {
        if (this.characterList != other.characterList && (this.charPosMap == null || other.charPosMap == null)) {
            log.error("Merging two non-empty Character position tracker with different character lists");
        }
        HashSet newCharacterList = Sets.newHashSet();
        newCharacterList.addAll(this.characterList);
        newCharacterList.addAll(other.characterList);
        HashMap newCharPosMap = Maps.newHashMap();
        newCharacterList.forEach(c -> {
            NumberTracker tracker = this.charPosMap.get(c);
            NumberTracker otherTracker = other.charPosMap.get(c);
            if (tracker != null && otherTracker != null) {
                newCharPosMap.put(c, tracker.merge(otherTracker));
            } else if (tracker != null) {
                newCharPosMap.put(c, tracker);
            } else if (otherTracker != null) {
                newCharPosMap.put(c, otherTracker);
            }
        });
        NumberTracker nitlTracker = this.charPosMap.get(Character.valueOf('\u0000'));
        NumberTracker otherNitlTracker = other.charPosMap.get(Character.valueOf('\u0000'));
        if (nitlTracker != null && otherNitlTracker != null) {
            newCharPosMap.put(Character.valueOf('\u0000'), nitlTracker.merge(otherNitlTracker));
        } else if (nitlTracker != null) {
            newCharPosMap.put(Character.valueOf('\u0000'), nitlTracker);
        } else if (otherNitlTracker != null) {
            newCharPosMap.put(Character.valueOf('\u0000'), otherNitlTracker);
        }
        return new CharPosTracker(newCharacterList, (Map<Character, NumberTracker>)newCharPosMap);
    }

    public CharPosMessage toProtobuf() {
        Map<String, NumbersMessage> mapMsg = this.charPosMap.entrySet().stream().collect(Collectors.toMap(e -> ((Character)e.getKey()).toString(), e -> ((NumberTracker)e.getValue()).toProtobuf().build()));
        return CharPosMessage.newBuilder().putAllCharPosMap(mapMsg).setCharList(Joiner.on((String)"").join(this.characterList)).build();
    }

    public static CharPosTracker fromProtobuf(CharPosMessage msg) {
        HashMap map = Maps.newHashMap();
        msg.getCharPosMapMap().forEach((k, v) -> map.put(Character.valueOf(k.charAt(0)), NumberTracker.fromProtobuf(v)));
        return new CharPosTracker(msg.getCharList(), (Map<Character, NumberTracker>)map);
    }

    public CharPosSummary toSummary() {
        HashMap map = Maps.newHashMap();
        Character nullChar = new Character('\u0000');
        this.charPosMap.forEach((k, v) -> map.put(k.equals(nullChar) ? "NITL" : k.toString(), SummaryConverters.fromNumberTracker(v)));
        return CharPosSummary.newBuilder().setCharacterList(Joiner.on((String)"").join(this.characterList)).putAllCharPosMap(map).build();
    }

    public CharPosTracker(Set<Character> characterList, Map<Character, NumberTracker> charPosMap) {
        this.characterList = characterList;
        this.charPosMap = charPosMap;
    }

    public Map<Character, NumberTracker> getCharPosMap() {
        return this.charPosMap;
    }
}

