/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.statistics.datatypes;

import com.google.protobuf.ByteString;
import com.whylogs.core.message.StringsMessage;
import com.whylogs.core.statistics.NumberTracker;
import com.whylogs.core.statistics.datatypes.CharPosTracker;
import com.whylogs.core.utils.sketches.ThetaSketch;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Union;

public final class StringTracker {
    public static Function<String, List<String>> TOKENIZER = str -> Arrays.asList(str.split(" "));
    public static final ArrayOfStringsSerDe ARRAY_OF_STRINGS_SER_DE = new ArrayOfStringsSerDe();
    public static final int MAX_FREQUENT_ITEM_SIZE = 128;
    private long count;
    private final ItemsSketch<String> items;
    private final Union thetaSketch;
    private final NumberTracker length;
    private final NumberTracker tokenLength;
    private final CharPosTracker charPosTracker;
    private Function<String, List<String>> tokenizer;

    public StringTracker() {
        this.count = 0L;
        this.items = new ItemsSketch(128);
        this.thetaSketch = Union.builder().buildUnion();
        this.length = new NumberTracker();
        this.tokenLength = new NumberTracker();
        this.charPosTracker = new CharPosTracker();
        this.tokenizer = TOKENIZER;
    }

    public void update(String value) {
        this.update(value, null);
    }

    public void update(String value, String charString) {
        if (value == null) {
            return;
        }
        ++this.count;
        this.thetaSketch.update(value);
        this.items.update((Object)value);
        this.charPosTracker.update(value, charString);
        this.length.track(value.length());
        this.tokenLength.track(this.tokenizer.apply(value).size());
    }

    public void update(String value, String charString, Function<String, List<String>> tokenizer) {
        if (tokenizer != null) {
            this.tokenizer = tokenizer;
        }
        this.update(value, charString);
    }

    public StringTracker merge(StringTracker other) {
        byte[] bytes;
        ItemsSketch itemsCopy = null;
        if (this.items != null) {
            bytes = this.items.toByteArray((ArrayOfItemsSerDe)ARRAY_OF_STRINGS_SER_DE);
            itemsCopy = ItemsSketch.getInstance((Memory)WritableMemory.wrap((byte[])bytes), (ArrayOfItemsSerDe)ARRAY_OF_STRINGS_SER_DE);
            itemsCopy.merge(other.items);
        } else if (other.items != null) {
            bytes = other.items.toByteArray((ArrayOfItemsSerDe)ARRAY_OF_STRINGS_SER_DE);
            itemsCopy = ItemsSketch.getInstance((Memory)WritableMemory.wrap((byte[])bytes), (ArrayOfItemsSerDe)ARRAY_OF_STRINGS_SER_DE);
        }
        Union thetaUnion = Union.builder().buildUnion();
        thetaUnion.update((Sketch)this.thetaSketch.getResult());
        thetaUnion.update((Sketch)other.thetaSketch.getResult());
        NumberTracker newLength = this.length.merge(other.length);
        NumberTracker newTokenLength = this.tokenLength.merge(other.tokenLength);
        CharPosTracker newCharPostTracker = this.charPosTracker.merge(other.charPosTracker);
        return StringTracker.builder().count(this.count + other.count).items((ItemsSketch<String>)itemsCopy).thetaSketch(thetaUnion).length(newLength).tokenLength(newTokenLength).charPosTracker(newCharPostTracker).build();
    }

    public StringsMessage.Builder toProtobuf() {
        StringsMessage.Builder builder = StringsMessage.newBuilder().setCount(this.count).setCompactTheta(ThetaSketch.serialize(this.thetaSketch)).setLength(this.length.toProtobuf()).setTokenLength(this.tokenLength.toProtobuf()).setCharPosTracker(this.charPosTracker.toProtobuf());
        if (this.items != null) {
            builder.setItems(ByteString.copyFrom((byte[])this.items.toByteArray((ArrayOfItemsSerDe)ARRAY_OF_STRINGS_SER_DE)));
        }
        return builder;
    }

    public static StringTracker fromProtobuf(StringsMessage message) {
        ItemsSketch items = null;
        byte[] ba = message.getItems().toByteArray();
        if (ba.length > 8) {
            Memory iMem = Memory.wrap((byte[])ba);
            items = ItemsSketch.getInstance((Memory)iMem, (ArrayOfItemsSerDe)ARRAY_OF_STRINGS_SER_DE);
        }
        StringTrackerBuilder builder = StringTracker.builder().count(message.getCount()).items(items).thetaSketch(ThetaSketch.deserialize(message.getCompactTheta()));
        if (message.hasLength()) {
            builder.length(NumberTracker.fromProtobuf(message.getLength())).tokenLength(NumberTracker.fromProtobuf(message.getTokenLength())).charPosTracker(CharPosTracker.fromProtobuf(message.getCharPosTracker()));
        }
        return builder.build();
    }

    private static Function<String, List<String>> $default$tokenizer() {
        return TOKENIZER;
    }

    public static StringTrackerBuilder builder() {
        return new StringTrackerBuilder();
    }

    public long getCount() {
        return this.count;
    }

    public ItemsSketch<String> getItems() {
        return this.items;
    }

    public Union getThetaSketch() {
        return this.thetaSketch;
    }

    public NumberTracker getLength() {
        return this.length;
    }

    public NumberTracker getTokenLength() {
        return this.tokenLength;
    }

    public CharPosTracker getCharPosTracker() {
        return this.charPosTracker;
    }

    public Function<String, List<String>> getTokenizer() {
        return this.tokenizer;
    }

    private StringTracker(long count, ItemsSketch<String> items, Union thetaSketch, NumberTracker length, NumberTracker tokenLength, CharPosTracker charPosTracker, Function<String, List<String>> tokenizer) {
        this.count = count;
        this.items = items;
        this.thetaSketch = thetaSketch;
        this.length = length;
        this.tokenLength = tokenLength;
        this.charPosTracker = charPosTracker;
        this.tokenizer = tokenizer;
    }

    public static class StringTrackerBuilder {
        private long count;
        private ItemsSketch<String> items;
        private Union thetaSketch;
        private NumberTracker length;
        private NumberTracker tokenLength;
        private CharPosTracker charPosTracker;
        private boolean tokenizer$set;
        private Function<String, List<String>> tokenizer$value;

        StringTrackerBuilder() {
        }

        public StringTrackerBuilder count(long count) {
            this.count = count;
            return this;
        }

        public StringTrackerBuilder items(ItemsSketch<String> items) {
            this.items = items;
            return this;
        }

        public StringTrackerBuilder thetaSketch(Union thetaSketch) {
            this.thetaSketch = thetaSketch;
            return this;
        }

        public StringTrackerBuilder length(NumberTracker length) {
            this.length = length;
            return this;
        }

        public StringTrackerBuilder tokenLength(NumberTracker tokenLength) {
            this.tokenLength = tokenLength;
            return this;
        }

        public StringTrackerBuilder charPosTracker(CharPosTracker charPosTracker) {
            this.charPosTracker = charPosTracker;
            return this;
        }

        public StringTrackerBuilder tokenizer(Function<String, List<String>> tokenizer) {
            this.tokenizer$value = tokenizer;
            this.tokenizer$set = true;
            return this;
        }

        public StringTracker build() {
            Function tokenizer$value = this.tokenizer$value;
            if (!this.tokenizer$set) {
                tokenizer$value = StringTracker.$default$tokenizer();
            }
            return new StringTracker(this.count, this.items, this.thetaSketch, this.length, this.tokenLength, this.charPosTracker, tokenizer$value);
        }

        public String toString() {
            return "StringTracker.StringTrackerBuilder(count=" + this.count + ", items=" + this.items + ", thetaSketch=" + this.thetaSketch + ", length=" + this.length + ", tokenLength=" + this.tokenLength + ", charPosTracker=" + this.charPosTracker + ", tokenizer$value=" + this.tokenizer$value + ")";
        }
    }
}

