/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core;

import com.google.common.collect.Sets;
import com.whylogs.core.message.ModelProfileMessage;
import com.whylogs.core.message.ModelType;
import com.whylogs.core.metrics.ModelMetrics;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelProfile {
    private static final Logger log = LoggerFactory.getLogger(ModelProfile.class);
    private final Set<String> outputFields;
    @NonNull
    private final ModelMetrics metrics;

    public ModelProfile(String prediction, String target, String score, Iterable<String> additionalOutputFields) {
        this.outputFields = Sets.newHashSet(additionalOutputFields);
        this.outputFields.add(prediction);
        this.metrics = new ModelMetrics(prediction, target, score);
    }

    public ModelProfile(String prediction, String target, Iterable<String> additionalOutputFields) {
        this.outputFields = Sets.newHashSet(additionalOutputFields);
        this.outputFields.add(prediction);
        this.metrics = new ModelMetrics(prediction, target);
    }

    public ModelProfileMessage.Builder toProtobuf() {
        ModelProfileMessage.Builder builder = ModelProfileMessage.newBuilder();
        builder.addAllOutputFields(this.outputFields);
        builder.setMetrics(this.metrics.toProtobuf());
        return builder;
    }

    @Nullable
    public static ModelProfile fromProtobuf(@Nullable ModelProfileMessage message) {
        if (message == null || message.getSerializedSize() == 0 || message.getMetrics().getModelType().equals((Object)ModelType.UNKNOWN)) {
            return null;
        }
        ModelMetrics metrics = ModelMetrics.fromProtobuf(message.getMetrics());
        if (metrics == null) {
            return null;
        }
        HashSet outputFields = Sets.newHashSet((Iterable)message.getOutputFieldsList());
        if (outputFields.isEmpty()) {
            log.warn("Empty output fields. This is not supposed to happen");
        }
        return new ModelProfile(outputFields, metrics);
    }

    @NonNull
    public ModelProfile merge(@Nullable ModelProfile other) {
        if (other == null) {
            ModelMetrics metricsCopy = this.metrics.copy();
            return new ModelProfile(Sets.newHashSet(this.outputFields), metricsCopy);
        }
        if (!this.outputFields.equals(other.outputFields)) {
            log.warn("Output fields don't match. Using the current output fields");
        }
        return new ModelProfile(Sets.newHashSet(this.outputFields), this.metrics.merge(other.metrics));
    }

    public ModelProfile copy() {
        return this.merge(null);
    }

    public void track(Map<String, ?> columns) {
        this.metrics.track(columns);
    }

    private ModelProfile(Set<String> outputFields, @NonNull ModelMetrics metrics) {
        if (metrics == null) {
            throw new NullPointerException("metrics is marked non-null but is null");
        }
        this.outputFields = outputFields;
        this.metrics = metrics;
    }

    @NonNull
    public ModelMetrics getMetrics() {
        return this.metrics;
    }
}

