/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.metrics;

import com.google.common.base.Preconditions;
import com.whylogs.core.message.ModelMetricsMessage;
import com.whylogs.core.message.ModelType;
import com.whylogs.core.metrics.ClassificationMetrics;
import com.whylogs.core.metrics.RegressionMetrics;
import java.util.Map;
import javax.annotation.Nullable;

public class ModelMetrics {
    private final ModelType modelType;
    private final ClassificationMetrics classificationMetrics;
    private final RegressionMetrics regressionMetrics;

    public ModelMetrics(String predictionField, String targetField, String scoreField) {
        this(ModelType.CLASSIFICATION, new ClassificationMetrics(predictionField, targetField, scoreField), null);
    }

    public ModelMetrics(String predictionField, String targetField) {
        this(ModelType.REGRESSION, null, new RegressionMetrics(predictionField, targetField));
    }

    public void track(Map<String, ?> columns) {
        switch (this.modelType) {
            case CLASSIFICATION: {
                this.classificationMetrics.track(columns);
                break;
            }
            case REGRESSION: {
                this.regressionMetrics.track(columns);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported model type: " + (Object)((Object)this.modelType));
            }
        }
    }

    public ModelMetricsMessage.Builder toProtobuf() {
        ModelMetricsMessage.Builder res = ModelMetricsMessage.newBuilder().setModelType(this.modelType);
        if (this.classificationMetrics != null) {
            res.setScoreMatrix(this.classificationMetrics.toProtobuf());
        }
        if (this.regressionMetrics != null) {
            res.setRegressionMetrics(this.regressionMetrics.toProtobuf());
        }
        return res;
    }

    public ModelMetrics merge(ModelMetrics other) {
        if (other == null) {
            return this;
        }
        Preconditions.checkArgument((this.modelType == other.modelType ? 1 : 0) != 0, (String)"Mismatched model type: expected %s, got %s", (Object[])new Object[]{this.modelType, other.modelType});
        switch (this.modelType) {
            case CLASSIFICATION: {
                ClassificationMetrics mergedMatrix = this.classificationMetrics.merge(other.classificationMetrics);
                return new ModelMetrics(this.modelType, mergedMatrix, null);
            }
            case REGRESSION: {
                RegressionMetrics mergedRegressionMetrics = this.regressionMetrics.merge(other.regressionMetrics);
                return new ModelMetrics(this.modelType, null, mergedRegressionMetrics);
            }
        }
        throw new IllegalArgumentException("Unsupported model type: " + (Object)((Object)this.modelType));
    }

    public ModelMetrics copy() {
        switch (this.modelType) {
            case CLASSIFICATION: {
                return new ModelMetrics(this.modelType, this.classificationMetrics.copy(), null);
            }
            case REGRESSION: {
                return new ModelMetrics(this.modelType, null, this.regressionMetrics.copy());
            }
        }
        throw new IllegalArgumentException("Unsupported model type: " + (Object)((Object)this.modelType));
    }

    @Nullable
    public static ModelMetrics fromProtobuf(@Nullable ModelMetricsMessage msg) {
        if (msg == null || msg.getSerializedSize() == 0) {
            return null;
        }
        ClassificationMetrics classificationMetrics = ClassificationMetrics.fromProtobuf(msg.getScoreMatrix());
        RegressionMetrics regressionMetrics = RegressionMetrics.fromProtobuf(msg.getRegressionMetrics());
        ModelType modelType = msg.getModelType();
        switch (modelType) {
            case CLASSIFICATION: {
                if (classificationMetrics != null) {
                    return new ModelMetrics(modelType, classificationMetrics, null);
                }
            }
            case REGRESSION: {
                if (regressionMetrics == null) break;
                return new ModelMetrics(modelType, null, regressionMetrics);
            }
        }
        return null;
    }

    private ModelMetrics(ModelType modelType, ClassificationMetrics classificationMetrics, RegressionMetrics regressionMetrics) {
        this.modelType = modelType;
        this.classificationMetrics = classificationMetrics;
        this.regressionMetrics = regressionMetrics;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public ClassificationMetrics getClassificationMetrics() {
        return this.classificationMetrics;
    }

    public RegressionMetrics getRegressionMetrics() {
        return this.regressionMetrics;
    }
}

