/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.utils.sketches;

import com.google.protobuf.ByteString;
import com.whylogs.core.message.FrequentItemsSketchMessage;
import com.whylogs.core.message.FrequentNumbersSketchMessage;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.memory.Memory;

public final class FrequentStringsSketch {
    public static final int FREQUENT_MAX_LG_K = 7;
    public static final ArrayOfStringsSerDe ARRAY_OF_STRINGS_SER_DE = new ArrayOfStringsSerDe();

    public static ItemsSketch<String> create() {
        return new ItemsSketch((int)Math.pow(2.0, 7.0));
    }

    public static ByteString serialize(ItemsSketch<String> sketch) {
        return ByteString.copyFrom((byte[])sketch.toByteArray((ArrayOfItemsSerDe)ARRAY_OF_STRINGS_SER_DE));
    }

    public static FrequentItemsSketchMessage.Builder toStringSketch(ItemsSketch<String> sketch) {
        return FrequentItemsSketchMessage.newBuilder().setLgMaxK(7).setSketch(ByteString.copyFrom((byte[])sketch.toByteArray((ArrayOfItemsSerDe)ARRAY_OF_STRINGS_SER_DE)));
    }

    public static FrequentNumbersSketchMessage.Builder toNumbersMessage(ItemsSketch<String> sketch) {
        return FrequentNumbersSketchMessage.newBuilder().setLgMaxK(7).setSketch(ByteString.copyFrom((byte[])sketch.toByteArray((ArrayOfItemsSerDe)ARRAY_OF_STRINGS_SER_DE)));
    }

    public static ItemsSketch<String> deserialize(ByteString bytes) {
        byte[] data = bytes.toByteArray();
        if (data.length > 8) {
            return ItemsSketch.getInstance((Memory)Memory.wrap((byte[])data), (ArrayOfItemsSerDe)ARRAY_OF_STRINGS_SER_DE);
        }
        return FrequentStringsSketch.create();
    }

    private FrequentStringsSketch() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

