/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import com.whylogs.core.SummaryConverters;
import com.whylogs.core.message.ColumnMessage;
import com.whylogs.core.message.ColumnSummary;
import com.whylogs.core.message.HllSketchMessage;
import com.whylogs.core.message.InferredType;
import com.whylogs.core.message.NumberSummary;
import com.whylogs.core.message.SchemaSummary;
import com.whylogs.core.message.StringsSummary;
import com.whylogs.core.statistics.CountersTracker;
import com.whylogs.core.statistics.NumberTracker;
import com.whylogs.core.statistics.SchemaTracker;
import com.whylogs.core.statistics.datatypes.StringTracker;
import com.whylogs.core.types.TypedData;
import com.whylogs.core.types.TypedDataConverter;
import com.whylogs.core.utils.sketches.FrequentStringsSketch;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.memory.Memory;

public class ColumnProfile {
    public static final int FREQUENT_MAX_LG_K = 7;
    private static final int CARDINALITY_LG_K = 12;
    public static final int STRING_LENGTH_MAX = 256;
    private static volatile ImmutableSet<String> NULL_STR_ENVS;
    @NonNull
    private final String columnName;
    @NonNull
    private final CountersTracker counters;
    @NonNull
    private final SchemaTracker schemaTracker;
    @NonNull
    private final NumberTracker numberTracker;
    @NonNull
    private final ItemsSketch<String> frequentItems;
    @NonNull
    private final HllSketch cardinalityTracker;
    @NonNull
    private final ImmutableSet<String> nullStrs;
    @NonNull
    private final StringTracker stringTracker;

    static ImmutableSet<String> nullStrsFromEnv() {
        if (NULL_STR_ENVS == null) {
            String nullSpec = System.getenv("NULL_STRINGS");
            NULL_STR_ENVS = nullSpec == null ? ImmutableSet.of() : ImmutableSet.copyOf((Object[])nullSpec.split(","));
        }
        return NULL_STR_ENVS;
    }

    public ColumnProfile(String columnName) {
        this(columnName, ColumnProfile.nullStrsFromEnv());
    }

    public ColumnProfile(String columnName, ImmutableSet<String> nullStrs) {
        this.columnName = columnName;
        this.counters = new CountersTracker();
        this.schemaTracker = new SchemaTracker();
        this.stringTracker = new StringTracker();
        this.numberTracker = new NumberTracker();
        this.frequentItems = FrequentStringsSketch.create();
        this.cardinalityTracker = new HllSketch(12);
        this.nullStrs = nullStrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void track(Object value) {
        ColumnProfile columnProfile = this;
        synchronized (columnProfile) {
            this.counters.incrementCount();
            TypedData typedData = TypedDataConverter.convert(value);
            if (this.isNull(typedData)) {
                this.schemaTracker.track(InferredType.Type.NULL);
                return;
            }
            this.schemaTracker.track(typedData.getType());
            switch (typedData.getType()) {
                case FRACTIONAL: {
                    double fractional = typedData.getFractional();
                    this.trackText(String.valueOf(fractional));
                    this.numberTracker.track(fractional);
                    break;
                }
                case INTEGRAL: {
                    long integralValue = typedData.getIntegralValue();
                    this.trackText(String.valueOf(integralValue));
                    this.numberTracker.track(integralValue);
                    break;
                }
                case BOOLEAN: {
                    this.trackText(String.valueOf(typedData.isBooleanValue()));
                    if (!typedData.isBooleanValue()) break;
                    this.counters.incrementTrue();
                    break;
                }
                case STRING: {
                    String stringValue = typedData.getStringValue();
                    this.trackText(stringValue);
                    this.stringTracker.update(stringValue);
                }
            }
        }
    }

    private boolean isNull(TypedData value) {
        if (value == null) {
            return true;
        }
        if (value.getType() == InferredType.Type.STRING && !this.nullStrs.isEmpty()) {
            return this.nullStrs.contains((Object)value.getStringValue());
        }
        if (value.getType() == InferredType.Type.FRACTIONAL) {
            return Double.isNaN(value.getFractional()) || Double.isInfinite(value.getFractional());
        }
        return false;
    }

    private void trackText(String text) {
        if (text != null && text.length() > 256) {
            text = text.substring(0, 256);
        }
        this.frequentItems.update((Object)text);
        this.cardinalityTracker.update(text);
    }

    public ColumnSummary toColumnSummary() {
        SchemaSummary.Builder schema = SummaryConverters.fromSchemaTracker(this.schemaTracker);
        ColumnSummary.Builder builder = ColumnSummary.newBuilder().setCounters(this.counters.toProtobuf());
        if (schema != null) {
            builder.setSchema(schema);
            if (TypedDataConverter.NUMERIC_TYPES.contains((Object)schema.getInferredType().getType())) {
                StringsSummary stringsSummary = SummaryConverters.fromStringTracker(this.stringTracker);
                NumberSummary numberSummary = SummaryConverters.fromNumberTracker(this.numberTracker);
                if (numberSummary != null) {
                    builder.setNumberSummary(numberSummary);
                }
            }
        }
        return builder.build();
    }

    public ColumnProfile merge(ColumnProfile other) {
        return this.merge(other, true);
    }

    public ColumnProfile merge(ColumnProfile other, boolean checkName) {
        if (checkName) {
            Preconditions.checkArgument((boolean)this.columnName.equals(other.columnName), (Object)String.format("Mismatched column name. Expected [%s], got [%s]", this.columnName, other.columnName));
        }
        Union mergedSketch = Union.heapify((byte[])this.cardinalityTracker.toCompactByteArray());
        mergedSketch.update(other.cardinalityTracker);
        Memory iMem = Memory.wrap((byte[])this.frequentItems.toByteArray((ArrayOfItemsSerDe)StringTracker.ARRAY_OF_STRINGS_SER_DE));
        ItemsSketch copyFreqItems = ItemsSketch.getInstance((Memory)iMem, (ArrayOfItemsSerDe)StringTracker.ARRAY_OF_STRINGS_SER_DE);
        copyFreqItems.merge(other.frequentItems);
        ColumnProfileBuilder builder = ColumnProfile.builder().setColumnName(this.columnName).setCounters(this.counters.merge(other.counters)).setNumberTracker(this.numberTracker.merge(other.numberTracker)).setSchemaTracker(this.schemaTracker.merge(other.schemaTracker)).setCardinalityTracker(HllSketch.heapify((byte[])mergedSketch.toCompactByteArray())).setFrequentItems((ItemsSketch<String>)copyFreqItems).setNullStrs((ImmutableSet<String>)Sets.union(this.getNullStrs(), other.getNullStrs()).immutableCopy());
        if (this.stringTracker == null) {
            builder.setStringTracker(other.stringTracker);
        } else {
            builder.setStringTracker(this.stringTracker.merge(other.stringTracker));
        }
        return builder.build();
    }

    public ColumnMessage.Builder toProtobuf() {
        HllSketchMessage.Builder hllSketchMessage = HllSketchMessage.newBuilder().setLgK(this.cardinalityTracker.getLgConfigK()).setSketch(ByteString.copyFrom((byte[])this.cardinalityTracker.toCompactByteArray()));
        return ColumnMessage.newBuilder().setName(this.columnName).setCounters(this.counters.toProtobuf()).setSchema(this.schemaTracker.toProtobuf()).setNumbers(this.numberTracker.toProtobuf()).setStrings(this.stringTracker.toProtobuf()).setCardinalityTracker(hllSketchMessage).setFrequentItems(FrequentStringsSketch.toStringSketch(this.frequentItems));
    }

    @Nullable
    public static ColumnProfile fromProtobuf(@Nullable ColumnMessage message) {
        if (message == null || message.getSerializedSize() == 0) {
            return null;
        }
        ColumnProfileBuilder builder = ColumnProfile.builder().setColumnName(message.getName()).setCounters(CountersTracker.fromProtobuf(message.getCounters())).setSchemaTracker(SchemaTracker.fromProtobuf(message.getSchema(), message.getCounters().getNullCount().getValue())).setNumberTracker(NumberTracker.fromProtobuf(message.getNumbers())).setCardinalityTracker(HllSketch.heapify((byte[])message.getCardinalityTracker().getSketch().toByteArray())).setFrequentItems(FrequentStringsSketch.deserialize(message.getFrequentItems().getSketch())).setNullStrs(ColumnProfile.nullStrsFromEnv());
        StringTracker strTracker = message.hasStrings() ? StringTracker.fromProtobuf(message.getStrings()) : new StringTracker();
        builder.setStringTracker(strTracker);
        return builder.build();
    }

    public static ColumnProfileBuilder builder() {
        return new ColumnProfileBuilder();
    }

    private ColumnProfile(@NonNull String columnName, @NonNull CountersTracker counters, @NonNull SchemaTracker schemaTracker, @NonNull NumberTracker numberTracker, @NonNull ItemsSketch<String> frequentItems, @NonNull HllSketch cardinalityTracker, @NonNull ImmutableSet<String> nullStrs, @NonNull StringTracker stringTracker) {
        if (columnName == null) {
            throw new NullPointerException("columnName is marked non-null but is null");
        }
        if (counters == null) {
            throw new NullPointerException("counters is marked non-null but is null");
        }
        if (schemaTracker == null) {
            throw new NullPointerException("schemaTracker is marked non-null but is null");
        }
        if (numberTracker == null) {
            throw new NullPointerException("numberTracker is marked non-null but is null");
        }
        if (frequentItems == null) {
            throw new NullPointerException("frequentItems is marked non-null but is null");
        }
        if (cardinalityTracker == null) {
            throw new NullPointerException("cardinalityTracker is marked non-null but is null");
        }
        if (nullStrs == null) {
            throw new NullPointerException("nullStrs is marked non-null but is null");
        }
        if (stringTracker == null) {
            throw new NullPointerException("stringTracker is marked non-null but is null");
        }
        this.columnName = columnName;
        this.counters = counters;
        this.schemaTracker = schemaTracker;
        this.numberTracker = numberTracker;
        this.frequentItems = frequentItems;
        this.cardinalityTracker = cardinalityTracker;
        this.nullStrs = nullStrs;
        this.stringTracker = stringTracker;
    }

    @NonNull
    public String getColumnName() {
        return this.columnName;
    }

    @NonNull
    public CountersTracker getCounters() {
        return this.counters;
    }

    @NonNull
    public SchemaTracker getSchemaTracker() {
        return this.schemaTracker;
    }

    @NonNull
    public NumberTracker getNumberTracker() {
        return this.numberTracker;
    }

    @NonNull
    public ItemsSketch<String> getFrequentItems() {
        return this.frequentItems;
    }

    @NonNull
    public HllSketch getCardinalityTracker() {
        return this.cardinalityTracker;
    }

    @NonNull
    public ImmutableSet<String> getNullStrs() {
        return this.nullStrs;
    }

    @NonNull
    public StringTracker getStringTracker() {
        return this.stringTracker;
    }

    public static class ColumnProfileBuilder {
        private String columnName;
        private CountersTracker counters;
        private SchemaTracker schemaTracker;
        private NumberTracker numberTracker;
        private ItemsSketch<String> frequentItems;
        private HllSketch cardinalityTracker;
        private ImmutableSet<String> nullStrs;
        private StringTracker stringTracker;

        ColumnProfileBuilder() {
        }

        public ColumnProfileBuilder setColumnName(@NonNull String columnName) {
            if (columnName == null) {
                throw new NullPointerException("columnName is marked non-null but is null");
            }
            this.columnName = columnName;
            return this;
        }

        public ColumnProfileBuilder setCounters(@NonNull CountersTracker counters) {
            if (counters == null) {
                throw new NullPointerException("counters is marked non-null but is null");
            }
            this.counters = counters;
            return this;
        }

        public ColumnProfileBuilder setSchemaTracker(@NonNull SchemaTracker schemaTracker) {
            if (schemaTracker == null) {
                throw new NullPointerException("schemaTracker is marked non-null but is null");
            }
            this.schemaTracker = schemaTracker;
            return this;
        }

        public ColumnProfileBuilder setNumberTracker(@NonNull NumberTracker numberTracker) {
            if (numberTracker == null) {
                throw new NullPointerException("numberTracker is marked non-null but is null");
            }
            this.numberTracker = numberTracker;
            return this;
        }

        public ColumnProfileBuilder setFrequentItems(@NonNull ItemsSketch<String> frequentItems) {
            if (frequentItems == null) {
                throw new NullPointerException("frequentItems is marked non-null but is null");
            }
            this.frequentItems = frequentItems;
            return this;
        }

        public ColumnProfileBuilder setCardinalityTracker(@NonNull HllSketch cardinalityTracker) {
            if (cardinalityTracker == null) {
                throw new NullPointerException("cardinalityTracker is marked non-null but is null");
            }
            this.cardinalityTracker = cardinalityTracker;
            return this;
        }

        public ColumnProfileBuilder setNullStrs(@NonNull ImmutableSet<String> nullStrs) {
            if (nullStrs == null) {
                throw new NullPointerException("nullStrs is marked non-null but is null");
            }
            this.nullStrs = nullStrs;
            return this;
        }

        public ColumnProfileBuilder setStringTracker(@NonNull StringTracker stringTracker) {
            if (stringTracker == null) {
                throw new NullPointerException("stringTracker is marked non-null but is null");
            }
            this.stringTracker = stringTracker;
            return this;
        }

        public ColumnProfile build() {
            return new ColumnProfile(this.columnName, this.counters, this.schemaTracker, this.numberTracker, this.frequentItems, this.cardinalityTracker, this.nullStrs, this.stringTracker);
        }

        public String toString() {
            return "ColumnProfile.ColumnProfileBuilder(columnName=" + this.columnName + ", counters=" + this.counters + ", schemaTracker=" + this.schemaTracker + ", numberTracker=" + this.numberTracker + ", frequentItems=" + this.frequentItems + ", cardinalityTracker=" + this.cardinalityTracker + ", nullStrs=" + this.nullStrs + ", stringTracker=" + this.stringTracker + ")";
        }
    }
}

