/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.statistics;

import com.google.protobuf.Int64Value;
import com.whylogs.core.message.Counters;
import java.util.Optional;

public class CountersTracker {
    private long count;
    private long trueCount;

    public void incrementCount() {
        ++this.count;
    }

    public void incrementTrue() {
        ++this.trueCount;
    }

    public void add(CountersTracker other) {
        this.count += other.count;
        this.trueCount += other.trueCount;
    }

    public CountersTracker merge(CountersTracker other) {
        CountersTracker result = new CountersTracker();
        result.count = this.count + other.count;
        result.trueCount = this.trueCount + other.trueCount;
        return result;
    }

    public Counters.Builder toProtobuf() {
        Counters.Builder countersBuilder = Counters.newBuilder().setCount(this.count);
        if (this.trueCount > 0L) {
            countersBuilder.setTrueCount(Int64Value.of((long)this.trueCount));
        }
        return countersBuilder;
    }

    public static CountersTracker fromProtobuf(Counters message) {
        CountersTracker tracker = new CountersTracker();
        tracker.count = message.getCount();
        tracker.trueCount = Optional.of(message.getTrueCount()).map(Int64Value::getValue).orElse(0L);
        return tracker;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CountersTracker)) {
            return false;
        }
        CountersTracker other = (CountersTracker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        return this.getTrueCount() == other.getTrueCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CountersTracker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $count = this.getCount();
        result = result * 59 + (int)($count >>> 32 ^ $count);
        long $trueCount = this.getTrueCount();
        result = result * 59 + (int)($trueCount >>> 32 ^ $trueCount);
        return result;
    }

    public long getCount() {
        return this.count;
    }

    public long getTrueCount() {
        return this.trueCount;
    }
}

