/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.types;

import com.whylogs.core.message.InferredType;
import lombok.NonNull;

public final class TypedData {
    private static final TypedData UNKNOWN_INSTANCE = TypedDataBuilder.access$100(TypedDataBuilder.access$000(TypedData.builder(), InferredType.Type.UNKNOWN));
    private static final TypedData BOOLEAN_TRUE_INSTANCE = TypedDataBuilder.access$100(TypedDataBuilder.access$200(TypedDataBuilder.access$000(TypedData.builder(), InferredType.Type.BOOLEAN), true));
    private static final TypedData BOOLEAN_FALSE_INSTANCE = TypedDataBuilder.access$100(TypedDataBuilder.access$200(TypedDataBuilder.access$000(TypedData.builder(), InferredType.Type.BOOLEAN), false));
    @NonNull
    private final InferredType.Type type;
    private final boolean booleanValue;
    private final long integralValue;
    private final double fractional;
    private final String stringValue;

    public static TypedData booleanValue(boolean booleanValue) {
        if (booleanValue) {
            return BOOLEAN_TRUE_INSTANCE;
        }
        return BOOLEAN_FALSE_INSTANCE;
    }

    public static TypedData stringValue(String stringValue) {
        return TypedData.builder().setType(InferredType.Type.STRING).setStringValue(stringValue).build();
    }

    public static TypedData integralValue(long integralValue) {
        return TypedData.builder().setType(InferredType.Type.INTEGRAL).setIntegralValue(integralValue).build();
    }

    public static TypedData fractionalValue(double fractionalValue) {
        return TypedData.builder().setType(InferredType.Type.FRACTIONAL).setFractional(fractionalValue).build();
    }

    public static TypedData unknownValue() {
        return UNKNOWN_INSTANCE;
    }

    TypedData(@NonNull InferredType.Type type, boolean booleanValue, long integralValue, double fractional, String stringValue) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
        this.booleanValue = booleanValue;
        this.integralValue = integralValue;
        this.fractional = fractional;
        this.stringValue = stringValue;
    }

    private static TypedDataBuilder builder() {
        return new TypedDataBuilder();
    }

    @NonNull
    public InferredType.Type getType() {
        return this.type;
    }

    public boolean isBooleanValue() {
        return this.booleanValue;
    }

    public long getIntegralValue() {
        return this.integralValue;
    }

    public double getFractional() {
        return this.fractional;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypedData)) {
            return false;
        }
        TypedData other = (TypedData)o;
        if (this.isBooleanValue() != other.isBooleanValue()) {
            return false;
        }
        if (this.getIntegralValue() != other.getIntegralValue()) {
            return false;
        }
        if (Double.compare(this.getFractional(), other.getFractional()) != 0) {
            return false;
        }
        InferredType.Type this$type = this.getType();
        InferredType.Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$stringValue = this.getStringValue();
        String other$stringValue = other.getStringValue();
        return !(this$stringValue == null ? other$stringValue != null : !this$stringValue.equals(other$stringValue));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBooleanValue() ? 79 : 97);
        long $integralValue = this.getIntegralValue();
        result = result * 59 + (int)($integralValue >>> 32 ^ $integralValue);
        long $fractional = Double.doubleToLongBits(this.getFractional());
        result = result * 59 + (int)($fractional >>> 32 ^ $fractional);
        InferredType.Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $stringValue = this.getStringValue();
        result = result * 59 + ($stringValue == null ? 43 : $stringValue.hashCode());
        return result;
    }

    public String toString() {
        return "TypedData(type=" + (Object)((Object)this.getType()) + ", booleanValue=" + this.isBooleanValue() + ", integralValue=" + this.getIntegralValue() + ", fractional=" + this.getFractional() + ", stringValue=" + this.getStringValue() + ")";
    }

    private static class TypedDataBuilder {
        private InferredType.Type type;
        private boolean booleanValue;
        private long integralValue;
        private double fractional;
        private String stringValue;

        TypedDataBuilder() {
        }

        private TypedDataBuilder setType(@NonNull InferredType.Type type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        private TypedDataBuilder setBooleanValue(boolean booleanValue) {
            this.booleanValue = booleanValue;
            return this;
        }

        private TypedDataBuilder setIntegralValue(long integralValue) {
            this.integralValue = integralValue;
            return this;
        }

        private TypedDataBuilder setFractional(double fractional) {
            this.fractional = fractional;
            return this;
        }

        private TypedDataBuilder setStringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        private TypedData build() {
            return new TypedData(this.type, this.booleanValue, this.integralValue, this.fractional, this.stringValue);
        }

        public String toString() {
            return "TypedData.TypedDataBuilder(type=" + (Object)((Object)this.type) + ", booleanValue=" + this.booleanValue + ", integralValue=" + this.integralValue + ", fractional=" + this.fractional + ", stringValue=" + this.stringValue + ")";
        }

        static /* synthetic */ TypedDataBuilder access$200(TypedDataBuilder x0, boolean x1) {
            return x0.setBooleanValue(x1);
        }
    }
}

