package com.wordbox.ai.common.analytics.providers

import android.os.Bundle
import com.facebook.appevents.AppEventsLogger
import com.wordbox.ai.common.analytics.dsl.AnalyticEvent
import timber.log.Timber

class AnalyticsFacebook(
    private val logger: AppEventsLogger
) : AnalyticProvider {
    override fun register(analyticEvent: AnalyticEvent) {
        Timber.v("Facebook Event Name => ${analyticEvent.eventName}")
        val params = Bundle()
        analyticEvent.params?.forEach { paramEvent ->
            Timber.v("Facebook Event Param Name => ${paramEvent.name}")
            Timber.v("Facebook Event Param Name => ${paramEvent.value}")
            params.putString(paramEvent.name, paramEvent.value.toString())
        }
        logger.logEvent(analyticEvent.eventName, params)
    }
}
