package com.wordbox.ai.common.analytics.providers

import com.kochava.tracker.events.Events
import com.wordbox.ai.common.analytics.dsl.AnalyticEvent
import timber.log.Timber

class AnalyticsKochava : AnalyticProvider {
    override fun register(analyticEvent: AnalyticEvent) {

        val params = buildMap {
            analyticEvent.params?.forEach { paramEvent ->
                Timber.v("Kochava Event Param Name => ${paramEvent.name}")
                Timber.v("Kochava Event Param Name => ${paramEvent.value}")
                this[paramEvent.name] = paramEvent.value.toString()
            }
        }

        Timber.v("Kochava Event Name => ${analyticEvent.eventName}")

        Events.getInstance().sendWithDictionary(
            analyticEvent.eventName,
            params
        )
    }
}
