package com.wordbox.ai.common.error

import android.database.sqlite.SQLiteException
import java.net.HttpURLConnection
import retrofit2.HttpException

fun Exception.toCustomExceptions() = when (this) {
    is HttpException -> {
        when (this.code()) {
            HttpURLConnection.HTTP_UNAUTHORIZED -> Failure.HttpErrorUnauthorized(this)
            HttpURLConnection.HTTP_BAD_REQUEST -> Failure.HttpErrorBadRequest(this)
            HttpURLConnection.HTTP_NOT_FOUND -> Failure.HttpErrorNotFound(this)
            HttpURLConnection.HTTP_FORBIDDEN -> Failure.HttpErrorForbidden(this)
            HttpURLConnection.HTTP_INTERNAL_ERROR -> Failure.HttpErrorInternalServerError(this)
            else -> Failure.HttpError(this as Exception)
        }
    }
    is SQLiteException -> Failure.RoomSqlError(this)
    else -> Failure.GenericError(this)
}