package com.wordbox.ai.common.showcase

import android.app.Activity
import android.view.View

class ShowCaseBuilder(
    private val context: Activity,
    private val showCaseOne: ShowCaseView,
    private val showCaseTwo: ShowCaseView? = null,
    private val showCaseThree: ShowCaseView? = null,
    private val showCaseFour: ShowCaseView? = null,
    private val showCaseFive: ShowCaseView? = null
) {
    private constructor(builder: Builder) : this(
        builder.context,
        builder.showCaseOne,
        builder.showCaseTwo,
        builder.showCaseThree,
        builder.showCaseFour,
        builder.showCaseFive
    )

    class Builder(
        val context: Activity,
        val showCaseOne: ShowCaseView
    ) {

        var showCaseTwo: ShowCaseView? = null
            private set

        var showCaseThree: ShowCaseView? = null
            private set

        var showCaseFour: ShowCaseView? = null
            private set

        var showCaseFive: ShowCaseView? = null
            private set

        fun showCaseTwo(showCase: ShowCaseView) = apply { this.showCaseTwo = showCase }

        fun showCaseThree(showCase: ShowCaseView) = apply { this.showCaseThree = showCase }

        fun showCaseFour(showCase: ShowCaseView) = apply { this.showCaseFour = showCase }

        fun showCaseFive(showCase: ShowCaseView) = apply { this.showCaseFive = showCase }

        private fun showCaseFactory() {
            with(context) {
                addShowCase(showCaseOne) {
                    addShowCase(showCaseTwo) {
                        addShowCase(showCaseThree) {
                            addShowCase(showCaseFour) {
                                addShowCase(showCaseFive) { }
                            }
                        }
                    }
                }
            }
        }

        private fun Activity.addShowCase(view: ShowCaseView?, invoke: () -> Unit) {
            view?.let { noNullView ->
                showCaseExtension(
                    noNullView.view,
                    title = getString(noNullView.title),
                    content = getString(noNullView.content)
                ) {
                    invoke()
                    noNullView.callback?.invoke()
                }
            }
        }

        fun build() {
            showCaseFactory()
            ShowCaseBuilder(this)
        }
    }

    data class ShowCaseView(
        val view: View,
        val title: Int,
        val content: Int,
        val callback: (() -> Unit)? = null
    )

    companion object {
        inline fun build(context: Activity, viewOne: ShowCaseView, block: Builder.() -> Unit) =
            Builder(context, viewOne).apply(block).build()
    }
}
