package com.wordbox.ai.common.views

import android.graphics.ColorMatrix
import android.graphics.ColorMatrixColorFilter
import android.widget.ImageView
import androidx.core.content.ContextCompat
import com.bumptech.glide.Glide
import com.bumptech.glide.load.engine.DiskCacheStrategy
import com.bumptech.glide.load.resource.bitmap.CenterCrop
import com.bumptech.glide.load.resource.bitmap.RoundedCorners
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions
import com.bumptech.glide.request.RequestOptions
import com.wordbox.ai.common.common.androidext.R

const val SCALE_MULTIPLIER_SIZE = 0.7f
const val SATURATION_OFF = 0f
const val SATURATION_ON = 1f
const val ROUNDING_RADIUS = 60

fun ImageView.setImageVector(resId: Int) {
    setImageDrawable(ContextCompat.getDrawable(this.context, resId))
}

fun ImageView.setUrl(url: String) {
    this.post {
        Glide
            .with(this.context)
            .load(url)
            .diskCacheStrategy(DiskCacheStrategy.ALL)
            .apply(
                RequestOptions()
                    .override(this.width, this.height)
                    .centerCrop()
            )
            .placeholder(R.drawable.new_placeholder)
            .into(this)
    }
}

fun ImageView.setUrlCorners(url: String) {
    this.post {
        Glide
            .with(this.context)
            .load(url)
            .diskCacheStrategy(DiskCacheStrategy.ALL)
            .apply(
                RequestOptions()
                    .transform(CenterCrop(), RoundedCorners(ROUNDING_RADIUS))
            )
            .placeholder(R.drawable.new_placeholder)
            .into(this)
    }
}

fun ImageView.setUrlCircle(url: String) {
    Glide.with(this.context)
        .load(url)
        .circleCrop()
        .placeholder(R.drawable.new_placeholder)
        .into(this)
}

fun ImageView.setThumbnailCircle(url: String) {
    Glide.with(this.context)
        .load(url)
        .circleCrop()
        .thumbnail(SCALE_MULTIPLIER_SIZE)
        .transition(DrawableTransitionOptions.withCrossFade())
        .into(this)
}

fun ImageView.setGrayScale(mode: Boolean) {
    val colorMatrix = ColorMatrix()
    val saturation = if (mode) SATURATION_ON else SATURATION_OFF

    colorMatrix.setSaturation(saturation)

    colorFilter = ColorMatrixColorFilter(colorMatrix)
}

fun ImageView.setUrlCallback(url: String, execute: (() -> Unit)) {
    Glide.with(this.context)
        .load(url)
        .listener(listener(execute))
        .into(this)
}

fun ImageView.setThumbnail(url: String) {
    Glide.with(this.context)
        .load(url)
        .placeholder(R.drawable.new_placeholder)
        .thumbnail(SCALE_MULTIPLIER_SIZE)
        .centerCrop()
        .into(this)
}

fun ImageView.setGif(resource: Int? = null, url: String? = null) {
    Glide.with(this.context)
        .asGif()
        .load(url ?: resource)
        .diskCacheStrategy(DiskCacheStrategy.NONE)
        .skipMemoryCache(true)
        .into(this)
}

fun ImageView.setGifLoop(resource: Int, loopCount: Int) {
    Glide.with(this.context)
        .asGif()
        .load(resource)
        .diskCacheStrategy(DiskCacheStrategy.NONE)
        .skipMemoryCache(true)
        .listener(listenerGif(loopCount))
        .into(this)
}
