package com.wordbox.ai.common.showcase

import android.app.Activity
import android.view.View
import androidx.core.content.ContextCompat
import com.wordbox.ai.common.androidext.R
import uk.co.deanwild.materialshowcaseview.IShowcaseListener
import uk.co.deanwild.materialshowcaseview.MaterialShowcaseView

private const val SHAPE_PADDING = 5

fun Activity.showCaseExtension(
    targetView: View,
    title: String,
    content: String,
    callback: () -> Unit
) {
    val materialShowcaseView = MaterialShowcaseView.Builder(this)
        .apply {
            setTarget(targetView)
            setTitleText(title)
            setContentText(content)
            setShapePadding(SHAPE_PADDING)
            withCircleShape()
            setMaskColour(
                ContextCompat.getColor(
                    this@showCaseExtension,
                    R.color.colorBackgroundShowcase
                )
            )
            setContentTextColor(ContextCompat.getColor(this@showCaseExtension, R.color.colorWhite))
            setTitleTextColor(ContextCompat.getColor(this@showCaseExtension, R.color.colorWhite))
            setDismissOnTouch(true)
            setListener(object : IShowcaseListener {
                override fun onShowcaseDisplayed(showcaseView: MaterialShowcaseView?) {}

                override fun onShowcaseDismissed(showcaseView: MaterialShowcaseView?) {
                    callback.invoke()
                }
            })
        }

    materialShowcaseView.show()
}
