package com.wordbox.ai.common.views

import android.content.Context
import android.view.View
import androidx.annotation.StringRes
import androidx.fragment.app.Fragment
import com.google.android.material.snackbar.Snackbar
import com.wordbox.ai.common.androidext.R

fun Fragment.snackbar(@StringRes resId: Int, duration: Int = Snackbar.LENGTH_SHORT) =
    Snackbar.make(view!!, resId, duration).apply { show() }

fun Context.snackbar(view: View, @StringRes resId: Int, duration: Int = Snackbar.LENGTH_SHORT) =
    Snackbar.make(view, resId, duration).apply { show() }

fun Snackbar.showSuccess() = this.apply {
    view.backgroundColor(R.color.colorDarkModerateLimeGreen)
}

fun Snackbar.showWarning() = this.apply {
    view.backgroundColor(R.color.colorSoftOrange)
}

fun Snackbar.showError() = this.apply {
    view.backgroundColor(R.color.colorModerateRed)
}

fun Snackbar.showNeutral() = this.apply {
    view.backgroundColor(R.color.colorVeryDarkGray)
}
