package com.wordbox.ai.common.fragment

import android.view.View
import android.view.inputmethod.InputMethodManager
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentActivity
import com.google.android.material.snackbar.Snackbar
import com.wordbox.ai.common.activity.BaseCommonActivity
import com.wordbox.ai.common.androidext.R
import com.wordbox.ai.common.network.Failure
import com.wordbox.ai.common.views.showError
import com.wordbox.ai.common.views.showNeutral
import com.wordbox.ai.common.views.showWarning
import com.wordbox.ai.common.views.snackbar
import com.wordbox.ai.common.views.snackbarWithDismissAction

abstract class BaseFragmentBindingActivity : FragmentActivity(), BaseCommonActivity {
    private lateinit var layoutContainer: View

    fun setLayoutContainer(layout: View) {
        layoutContainer = layout
    }

    fun addFragment(fragment: Fragment) {
        supportFragmentManager
            .beginTransaction()
            .add(layoutContainer.id, fragment)
            .commit()
    }

    fun removeFragment(fragment: Fragment) {
        supportFragmentManager
            .beginTransaction()
            .remove(fragment)
            .commit()
    }

    override fun handleFailure(failure: com.wordbox.ai.common.network.Failure) {
        when (failure) {
            is com.wordbox.ai.common.network.Failure.NetworkConnection -> snackbarWithDismissAction(
                window.decorView.rootView,
                R.string.error_network_connection,
                Snackbar.LENGTH_INDEFINITE,
                R.string.button_ok
            ).showWarning()
            is com.wordbox.ai.common.network.Failure.CustomError -> snackbar(
                window.decorView.rootView,
                R.string.error_unavailable
            ).showWarning()
            is com.wordbox.ai.common.network.Failure.HttpError -> snackbar(
                window.decorView.rootView,
                R.string.error_server
            ).showError()
            is com.wordbox.ai.common.network.Failure.HttpErrorInternalServerError -> snackbar(
                window.decorView.rootView,
                R.string.error_server
            ).showError()
            is com.wordbox.ai.common.network.Failure.HttpErrorForbidden -> snackbar(
                window.decorView.rootView,
                R.string.error_server
            ).showError()
            is com.wordbox.ai.common.network.Failure.HttpErrorBadRequest -> snackbar(
                window.decorView.rootView,
                R.string.error_server
            ).showError()
            is com.wordbox.ai.common.network.Failure.HttpErrorUnauthorized -> snackbar(
                window.decorView.rootView,
                R.string.error_server
            ).showError()
            is com.wordbox.ai.common.network.Failure.RoomSqlError -> snackbar(
                window.decorView.rootView,
                R.string.error_unavailable
            ).showError()

            else -> snackbar(
                window.decorView.rootView,
                R.string.error_unavailable_unknown
            ).showNeutral()
        }
    }

    override fun hideKeyboard() {
        val imm: InputMethodManager = getSystemService(INPUT_METHOD_SERVICE) as InputMethodManager
        var view: View? = currentFocus
        if (view == null) {
            view = View(this)
        }
        imm.hideSoftInputFromWindow(view.windowToken, 0)
    }
}
