package com.wordbox.ai.common

import android.content.Context
import android.content.Context.VIBRATOR_SERVICE
import android.os.Build
import android.os.Build.VERSION.SDK_INT
import android.os.VibrationEffect
import android.os.VibrationEffect.DEFAULT_AMPLITUDE
import android.os.Vibrator

private const val LONG_VIBRATE = 700L
private const val SHORT_VIBRATE = 200L

fun Context.longVibrate() {
    val vibrator = this.getSystemService(VIBRATOR_SERVICE) as Vibrator
    vibrate(LONG_VIBRATE, vibrator)
}

fun Context.shortVibrate() {
    val vibrator = this.getSystemService(VIBRATOR_SERVICE) as Vibrator
    vibrate(SHORT_VIBRATE, vibrator)
}

fun Context.vibrate(milliseconds: Long) {
    val vibrator = this.getSystemService(VIBRATOR_SERVICE) as Vibrator
    vibrate(milliseconds, vibrator)
}

fun vibrate(milliseconds: Long, vibrator: Vibrator) {
    val canVibrate: Boolean = vibrator.hasVibrator()
    if (canVibrate) {
        if (SDK_INT >= Build.VERSION_CODES.O) {
            vibrator.vibrate(
                VibrationEffect.createOneShot(milliseconds, DEFAULT_AMPLITUDE)
            )
        } else {
            vibrator.vibrate(milliseconds)
        }
    }
}

fun exceptionUnknown() = Exception("Exception Unknown")
