package com.wordbox.ai.common.views

import androidx.recyclerview.widget.GridLayoutManager

private const val SPAN_COUNT_FIVE = 5
private const val SPAN_COUNT_FOURTH = 4
private const val SPAN_COUNT_THREE = 3
private const val SPAN_COUNT_ONE = 1
private const val SPAN_COUNT_ZERO = 0

fun customSpanSizeLookup() = object : GridLayoutManager.SpanSizeLookup() {
    override fun getSpanSize(position: Int): Int {
        return when {
            (position % SPAN_COUNT_FOURTH == SPAN_COUNT_ONE) -> SPAN_COUNT_FIVE
            (position % SPAN_COUNT_FOURTH == SPAN_COUNT_ZERO) -> SPAN_COUNT_THREE
            else -> SPAN_COUNT_FOURTH
        }
    }
}
