package com.wordbox.ai.common.views

import android.view.View
import android.view.View.GONE
import android.view.View.INVISIBLE
import android.view.View.VISIBLE
import android.view.animation.TranslateAnimation
import androidx.core.content.ContextCompat

fun View.visible() {
    this.visibility = VISIBLE
}

fun View.invisible() {
    this.visibility = INVISIBLE
}

fun View.gone() {
    this.visibility = GONE
}

fun View.setVisible(show: Boolean) {
    visibility = if (show) VISIBLE else GONE
}

fun View.backgroundColor(colorRes: Int) {
    setBackgroundColor(ContextCompat.getColor(context, colorRes))
}

fun View.getString(stringRes: Int): String = context.getString(stringRes)

fun View.getString(stringRes: Int, value: Any): String = context.getString(stringRes, value)

fun View.getPluralString(stringRes: Int, value: Int): String =
    context.resources.getQuantityString(stringRes, value, value)

fun View.slideUp(duration: Int = 500) {
    visibility = VISIBLE
    val animate = TranslateAnimation(0F, 0F, this.height.toFloat(), 0F)
    animate.duration = duration.toLong()
    animate.fillAfter = true
    this.startAnimation(animate)
}

fun View.slideDown(duration: Int = 500) {
    visibility = GONE
    val animate = TranslateAnimation(0F, 0F, 0F, this.height.toFloat())
    animate.duration = duration.toLong()
    animate.fillAfter = true
    this.startAnimation(animate)
}
