package com.wordbox.ai.common.domainmodel.usecase

import com.wordbox.ai.common.network.Failure
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.async
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.launch

abstract class UseCaseByFlow<out Type, in Params> where Type : Any {

    abstract suspend fun run(params: Params): Flow<Either<com.wordbox.ai.common.network.Failure, Type>>

    open operator fun invoke(
        scope: CoroutineScope,
        params: Params,
        onResult: (Flow<Either<com.wordbox.ai.common.network.Failure, Type>>) -> Unit = {}
    ) {
        val backgroundJob = scope.async { run(params) }
        scope.launch { onResult(backgroundJob.await()) }
    }

    class None
}
