package com.wordbox.ai.common.network

import com.google.android.gms.tasks.Task
import com.google.android.gms.tasks.Tasks
import com.google.firebase.auth.FirebaseAuth
import com.google.firebase.auth.GetTokenResult
import com.wordbox.network.constants.NetworkConstants.HEADER_AUTHORIZATION
import com.wordbox.network.constants.NetworkConstants.HEADER_AUTHORIZATION_VALUE
import okhttp3.Interceptor
import okhttp3.Response

class FirebaseUserIdTokenInterceptor : Interceptor {
    override fun intercept(chain: Interceptor.Chain): Response {
        var request = chain.request()
        val user = FirebaseAuth.getInstance().currentUser
        if (user != null) {
            val task: Task<GetTokenResult> = user.getIdToken(false)
            val tokenResult: GetTokenResult = Tasks.await(task)
            val idToken = tokenResult.token
            if (idToken != null) {
                request = request.newBuilder()
                    .addHeader(
                        HEADER_AUTHORIZATION, HEADER_AUTHORIZATION_VALUE + idToken
                    ).build()
            }
        }
        return chain.proceed(request)
    }
}
