package com.wordbox.ai.common.network

import android.content.Context
import com.chuckerteam.chucker.api.ChuckerInterceptor
import com.wordbox.network.constants.NetworkConstants.CHUCKER_MAX_CONTENT_LENGTH
import com.wordbox.network.constants.NetworkConstants.TIME_OUT
import java.util.concurrent.TimeUnit
import okhttp3.OkHttpClient
import okhttp3.logging.HttpLoggingInterceptor
import retrofit2.Retrofit
import retrofit2.converter.moshi.MoshiConverterFactory

fun createNetworkClient(
    baseUrl: String,
    debug: Boolean = false,
    context: Context
): Retrofit = retrofitClient(baseUrl, httpClient(debug, context))

private fun httpClient(debug: Boolean, context: Context): OkHttpClient {
    val httpLoggingInterceptor = HttpLoggingInterceptor(HttpLoggingInterceptor.Logger.DEFAULT)
    val clientBuilder = OkHttpClient.Builder()

    if (debug) {
        httpLoggingInterceptor.level = HttpLoggingInterceptor.Level.BODY

        clientBuilder.run {
            addInterceptor(httpLoggingInterceptor)
            addInterceptor(
                ChuckerInterceptor(
                    context = context,
                    maxContentLength = CHUCKER_MAX_CONTENT_LENGTH
                )
            )
        }
    }

    clientBuilder.addInterceptor(FirebaseUserIdTokenInterceptor())

    clientBuilder.run {
        connectTimeout(TIME_OUT, TimeUnit.SECONDS)
        readTimeout(TIME_OUT, TimeUnit.SECONDS).build()
    }

    return clientBuilder.build()
}

private fun retrofitClient(baseUrl: String, httpClient: OkHttpClient) =
    Retrofit.Builder()
        .baseUrl(baseUrl)
        .client(httpClient)
        .addConverterFactory(MoshiConverterFactory.create())
        .build()
