package ai.xpl.android.client;

import android.content.Context;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Config {
    public static final String DATA_API_URI = "https://dataapi-dev-7mvc6un3ya-ez.a.run.app";

    public static final String ROOT_DIR = "xplai";
    public static final String CONFIG_FILE_NAME = "config.json";
    private static final Gson gson = new GsonBuilder()
            .setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES)
            .setPrettyPrinting()
            .create();

    private static Config config;

    public Map<String, TaskData> tasksDataObjects = new ConcurrentHashMap<>();

    private Config(Map<String, TaskData> taskDataObjects) {
        this.tasksDataObjects = taskDataObjects;
    }

    private void save(Context context) {
        try {
            String json = gson.toJson(this.tasksDataObjects);
            File dir = context.getDir(ROOT_DIR, Context.MODE_PRIVATE);
            File configFile = new File(dir, CONFIG_FILE_NAME);
            FileOutputStream outputStream = new FileOutputStream(configFile);

            outputStream.write(json.getBytes(StandardCharsets.UTF_8));
            outputStream.close();
        }
        catch (Exception ignored){
            ignored.printStackTrace();
        }
    }
    public void putTaskData(Context context, TaskData taskData) {
        tasksDataObjects.put(taskData.taskId, taskData);
        save(context);
    }

    public TaskData getTaskData(String taskId){
        if (tasksDataObjects.containsKey(taskId)){
            return tasksDataObjects.get(taskId);
        }
        return null;
    }

    public static Config getInstance(Context context){
        if (Config.config != null){
            //// Config has been already loaded
            return Config.config;
        }

        //// Config wasn't loaded before
        if (Config.configFileExists(context)){
            //// Config file exists, hence load from file
            try {
                File dir = context.getDir(ROOT_DIR, Context.MODE_PRIVATE);
                File configFile = new File(dir, CONFIG_FILE_NAME);
                FileInputStream fileInputStream = new FileInputStream(configFile);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);

                ConcurrentHashMap<String, TaskData> data = gson.fromJson(inputStreamReader, new TypeToken<ConcurrentHashMap<String, TaskData>>() {}.getType());
                Config.config = new Config(data);
                inputStreamReader.close();
            } catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        else {
            //// Config has never been on the device, hence create new.
            Config.config = new Config(new ConcurrentHashMap<>());
        }

        //// at this point config has been initialized one way or another.
        return Config.config;
    }

    private static boolean configFileExists(Context context) {
        File dir = context.getDir(ROOT_DIR, Context.MODE_PRIVATE);
        File configFile = new File(dir, CONFIG_FILE_NAME);
        return configFile.exists();
    }
}