package ai.xpl.android.client;

import android.graphics.Bitmap;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.StringRequest;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DataApiClient {
    private static final Gson gson = new GsonBuilder()
            .setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES)
            .setPrettyPrinting()
            .create();

    public static void postDataPoint(RequestQueue requestQueue, DataPoint dataPoint, String taskApiKey){
        String url = Config.DATA_API_URI + "/upload/" + dataPoint.taskId + "/" + dataPoint.dataPointId;
        Map<String, byte[]> binaries = dataPoint.binaries;
        dataPoint.binaries = null;
        Map<String, Bitmap> bitmaps = dataPoint.bitmaps;
        dataPoint.bitmaps = null;

        StringRequest stringRequest = new StringRequest(Request.Method.POST, url,
            response -> {
                HashMap<String, ResourceForUpload> resoucesForUpload =
                    gson.fromJson(response, new TypeToken<HashMap<String, ResourceForUpload>>() {}.getType());
                //// upload binaries
                for(String fileName : binaries.keySet()){
//                    byte[] binary = binaries.get(fileName);
                    byte[] binary = makePng(bitmaps.get(fileName));
                    if (resoucesForUpload.containsKey(fileName)) {
                        dataPoint.fileUris.add(resoucesForUpload.get(fileName).url);
                        postBinary(requestQueue, binary, resoucesForUpload.get(fileName).urlForUpload);
                    }
                }
                //// upload data_point.json
                if (resoucesForUpload.containsKey("data_point.json")) {
                    byte[] binary = gson.toJson(dataPoint).getBytes(StandardCharsets.UTF_8);
                    postBinary(requestQueue, binary, resoucesForUpload.get("data_point.json").urlForUpload);
                }

                postDataPointMetadata(requestQueue, dataPoint, taskApiKey);
            },
            error -> { error.printStackTrace(); }
            ) {
                @Override
                public byte[] getBody() {
                    Object [] keyArray = binaries.keySet().toArray();
                    ArrayList<Object> fileNames = new ArrayList<>(Arrays.asList(keyArray));
                    fileNames.add("data_point.json");

                    String json = gson.toJson(fileNames.toArray());
                    return json.getBytes(StandardCharsets.UTF_8);
                }

                @Override
                public Map<String, String> getHeaders() {
                    Map<String, String>  params = new HashMap<>();
                    params.put("task_api_key", taskApiKey);
                    params.put("content-type", "application/json");

                    return params;
                }
            };

        requestQueue.add(stringRequest);
    }

    private static void postBinary(RequestQueue requestQueue, byte[] binary, String url){
        StringRequest stringRequest = new StringRequest(Request.Method.POST, url,
                response -> {
                },
                error -> {
                    error.printStackTrace();
                }) {

            @Override
            public byte[] getBody() {
                return binary;
            }

            @Override
            public Map<String, String> getHeaders() {
                Map<String, String>  params = new HashMap<>();
                params.put("content-type", "image/png");

                return params;
            }
        };

        requestQueue.add(stringRequest);
    }

    private static void postDataPointMetadata(RequestQueue requestQueue, DataPoint dataPoint, String taskApiKey) {
        String url = Config.DATA_API_URI + "/datapoints";
        dataPoint.binaries = null;

        StringRequest stringRequest = new StringRequest(Request.Method.POST, url,
                response -> {

                },
                error -> { error.printStackTrace(); }
        ) {
            @Override
            public byte[] getBody() {
                DataPoint [] dataPoints = new DataPoint[] {dataPoint};
                String json = gson.toJson(dataPoints);
                return json.getBytes(StandardCharsets.UTF_8);
            }

            @Override
            public Map<String, String> getHeaders() {
                Map<String, String>  params = new HashMap<>();
                params.put("task_api_key", taskApiKey);
                params.put("content-type", "application/json");

                return params;
            }
        };

        requestQueue.add(stringRequest);
    }

    private static byte[] makePng(Bitmap bitmap){
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, byteArrayOutputStream);

        byte[] result = byteArrayOutputStream.toByteArray();

        return result;
    }
}
