package ai.xpl.android.client;

import android.content.Context;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TaskPool {
    static String USER_API_URI = "https://userapi-dev-7mvc6un3ya-ez.a.run.app";
    static Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    static RequestQueue requestQueue;
    static Config config;
    static Boolean poolInitialized;

    public static void registerTask(Context context, String taskId, String taskApiKey) {
        if (TaskPool.requestQueue == null) {
            TaskPool.requestQueue = Volley.newRequestQueue(context);
        }

        if (TaskPool.config == null){
            TaskPool.config = Config.getInstance(context);
        }

        TaskPool.poolInitialized = true;

        reloadTask(context, taskId, taskApiKey);
    }

    public static Task getTask(Context context, String taskId) throws Exception {
        if (!poolInitialized) {
            throw new Exception("TaskPool has not been initialized. Initialize task pool" +
                    "by TaskPool.registerInstance for at least 1 Task");
        }

        TaskData taskData = TaskPool.config.getTaskData(taskId);
        if (taskData == null) {
            throw new Exception("Task wasn't registered in the pool." +
                                "Use TaskPool.registerInstance to register task.");
        }

        Task task = new Task(taskData, context, requestQueue);

        task.loadComponents(context);

        return task;
    }

    private static void reloadTask(Context context, String taskId, String taskApiKey) {
        TaskData localTaskData = TaskPool.config.getTaskData(taskId);
        String url = USER_API_URI + "/task/" + taskId;
        TaskData finalLocalTaskData = localTaskData;

        StringRequest stringRequest = new StringRequest(Request.Method.GET, url,
                response -> {
                    TaskData remoteTaskData = gson.fromJson(response, TaskData.class);

                    //// Only leave _cpu.ptl files and ignore the rest
                    ArrayList<String> removeComponents = new ArrayList<>();
                    for (ModelComponent modelComponent: remoteTaskData.model.components.values()) {
                        if (!modelComponent.name.endsWith(".ptl")) {
                            removeComponents.add(modelComponent.name);
                        }
                    }
                    for (String componentName: removeComponents){
                        remoteTaskData.model.components.remove(componentName);
                    }

//                    if (finalLocalTaskData != null && remoteTaskData.model.version != finalLocalTaskData.model.version){
//                        //// Task exists locally, but there is a new version remotely.
//                        tasksPendingUpdate.put(taskId, remoteTaskData);
//                    }

                    if (finalLocalTaskData == null) {
                        remoteTaskData.taskApiKey = taskApiKey;
                        TaskPool.config.putTaskData(context, remoteTaskData);
                    }

                    Task remoteTask = new Task(remoteTaskData, context, requestQueue);
                    for (String modelComponentKey: remoteTaskData.model.components.keySet()){
                        if (!remoteTask.componentFileExists(context, modelComponentKey)) {
                            remoteTask.downloadModelComponent(context, requestQueue, modelComponentKey);
                        }
                    }
                },
                error -> {
                    error.printStackTrace();
                    //      Handle error states
                    //        if response.status_code == 404:
                    //        raise TaskNotFoundException(f'Task "{task_id}" not found.')
                    //
                    //        elif response.status_code != 200:
                    //        raise Exception(f'Http error {response.status_code}.')
                }) {
            @Override
            public Map<String, String> getHeaders() {
                Map<String, String>  params = new HashMap<>();
                params.put("task_api_key", taskApiKey);

                return params;
            }
        };

        requestQueue.add(stringRequest);
    }
}
