/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.auth.client.client;

import ai.yue.library.auth.client.config.properties.AuthProperties;
import ai.yue.library.base.exception.LoginException;
import ai.yue.library.base.util.StringUtils;
import ai.yue.library.data.redis.client.Redis;
import ai.yue.library.web.util.servlet.ServletUtils;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class User {
    @Autowired
    protected Redis redis;
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    protected AuthProperties authProperties;

    public String getRequestToken() {
        Cookie cookie = ServletUtils.getCookie((String)this.authProperties.getCookieTokenKey());
        String token = "";
        token = cookie != null ? cookie.getValue() : this.request.getHeader(this.authProperties.getCookieTokenKey());
        return token;
    }

    public Long getUserId() {
        try {
            String token = this.getRequestToken();
            if (StringUtils.isEmpty((CharSequence)token)) {
                throw new LoginException("token == null");
            }
            String tokenValue = this.redis.get(this.authProperties.getRedisTokenPrefix() + token);
            return JSONObject.parseObject((String)tokenValue).getLong(this.authProperties.getUserKey());
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
    }

    public <T> T getUser(Class<T> clazz) {
        try {
            String token = this.getRequestToken();
            if (StringUtils.isEmpty((CharSequence)token)) {
                throw new LoginException("token == null");
            }
            String tokenValue = this.redis.get(this.authProperties.getRedisTokenPrefix() + token);
            Object t = JSONObject.parseObject((String)tokenValue, clazz);
            if (t == null) {
                throw new LoginException(null);
            }
            return (T)t;
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
    }
}

