/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.auth.client.config;

import ai.yue.library.auth.client.client.User;
import ai.yue.library.auth.client.config.properties.AuthProperties;
import ai.yue.library.data.redis.client.Redis;
import ai.yue.library.data.redis.config.RedisAutoConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@AutoConfigureAfter(value={RedisAutoConfig.class})
@EnableConfigurationProperties(value={AuthProperties.class})
public class AuthClientAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(AuthClientAutoConfig.class);

    @Bean
    @ConditionalOnBean(value={Redis.class})
    public User user() {
        log.info("\u3010\u521d\u59cb\u5316\u914d\u7f6e-AuthClient-User\u5ba2\u6237\u7aef\u3011\u914d\u7f6e\u9879\uff1ayue.auth\u3002Bean\uff1aUser ... \u5df2\u521d\u59cb\u5316\u5b8c\u6bd5\u3002");
        return new User();
    }

    @Bean
    public SecurityFilterChain endpointRequestSecurityFilterChain(HttpSecurity http) throws Exception {
        http.requestMatcher((RequestMatcher)EndpointRequest.toAnyEndpoint()).authorizeRequests(requests -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.anyRequest()).hasRole("ENDPOINT_ADMIN"));
        http.httpBasic();
        return (SecurityFilterChain)http.build();
    }
}

