/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.auth.service.client;

import ai.yue.library.auth.service.config.properties.AuthServiceProperties;
import ai.yue.library.auth.service.config.properties.QqProperties;
import ai.yue.library.auth.service.config.properties.WxOpenProperties;
import ai.yue.library.auth.service.dto.QqUserDTO;
import ai.yue.library.auth.service.dto.WxUserDTO;
import ai.yue.library.auth.service.vo.wx.open.AccessTokenVO;
import ai.yue.library.base.exception.ResultException;
import ai.yue.library.base.util.StringUtils;
import ai.yue.library.base.view.R;
import ai.yue.library.base.view.Result;
import ai.yue.library.web.ipo.CaptchaIPO;
import ai.yue.library.web.util.CaptchaUtils;
import ai.yue.library.web.util.ServletUtils;
import ai.yue.library.web.vo.CaptchaVO;
import com.alibaba.fastjson.JSONObject;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class User
extends ai.yue.library.auth.client.client.User {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private HttpServletResponse response;
    @Autowired
    private AuthServiceProperties authServiceProperties;
    @Autowired
    private WxOpenProperties wxOpenProperties;
    @Autowired
    private QqProperties qqProperties;
    private static final String WX_URI_ACCESS_TOKEN = "https://api.weixin.qq.com/sns/oauth2/access_token?appid={appid}&secret={secret}&code={code}&grant_type=authorization_code";
    private static final String WX_URI_USER_INFO = "https://api.weixin.qq.com/sns/userinfo?access_token={access_token}&openid={openid}";
    private static final String QQ_URI_USER_INFO = "https://graph.qq.com/user/get_user_info?oauth_consumer_key={oauth_consumer_key}&access_token={access_token}&openid={openid}";

    public AccessTokenVO getWxAccessToken(String code) {
        JSONObject paramJson = new JSONObject();
        paramJson.put("appid", (Object)this.wxOpenProperties.getAppid());
        paramJson.put("secret", (Object)this.wxOpenProperties.getSecret());
        paramJson.put("code", (Object)code);
        String result = (String)this.restTemplate.getForObject(WX_URI_ACCESS_TOKEN, String.class, (Map)paramJson);
        AccessTokenVO accessTokenVO = (AccessTokenVO)JSONObject.parseObject((String)result, AccessTokenVO.class);
        return accessTokenVO;
    }

    public WxUserDTO getWxUserInfo(String access_token, String openid) {
        JSONObject paramJson = new JSONObject();
        paramJson.put("access_token", (Object)access_token);
        paramJson.put("openid", (Object)openid);
        String result = (String)this.restTemplate.getForObject(WX_URI_USER_INFO, String.class, (Map)paramJson);
        WxUserDTO wxUserDTO = (WxUserDTO)JSONObject.parseObject((String)result, WxUserDTO.class);
        if (null == wxUserDTO.getOpenid()) {
            throw new ResultException(R.requestError((Object)result));
        }
        return wxUserDTO;
    }

    public QqUserDTO getQqUserInfo(String access_token, String openid) {
        JSONObject paramJson = new JSONObject();
        paramJson.put("oauth_consumer_key", (Object)this.qqProperties.getQqAppid());
        paramJson.put("access_token", (Object)access_token);
        paramJson.put("openid", (Object)openid);
        String result = (String)this.restTemplate.getForObject(QQ_URI_USER_INFO, String.class, (Map)paramJson);
        QqUserDTO qqUserDTO = (QqUserDTO)JSONObject.parseObject((String)result, QqUserDTO.class);
        if (null == qqUserDTO.getGender()) {
            throw new ResultException(R.requestError((Object)result));
        }
        return qqUserDTO;
    }

    public void getCaptchaImage() {
        CaptchaVO captchaVO = CaptchaUtils.createCaptchaImage((CaptchaIPO)CaptchaIPO.builder().build());
        String captcha = captchaVO.getCaptcha();
        BufferedImage captchaImage = captchaVO.getCaptchaImage();
        String captcha_redis_key = String.format("captcha_%s", captcha);
        this.redis.set(captcha_redis_key, captcha, (long)this.authServiceProperties.getCaptchaTimeout().intValue());
        HttpServletResponse response = ServletUtils.getResponse();
        response.setContentType("image/png");
        try {
            ServletOutputStream output = response.getOutputStream();
            ImageIO.write((RenderedImage)captchaImage, "png", (OutputStream)output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void captchaValidate(String captcha) {
        String captcha_redis_key = String.format("captcha_%s", captcha);
        String randCaptcha = this.redis.get(captcha_redis_key);
        if (StringUtils.isEmpty((CharSequence)randCaptcha) || !randCaptcha.equalsIgnoreCase(captcha)) {
            throw new ResultException(R.errorPrompt((String)"\u9a8c\u8bc1\u7801\u9519\u8bef"));
        }
        this.redis.del(captcha_redis_key);
    }

    public String login(Object userInfo) {
        String tokenValue;
        String token = this.getRequestToken();
        String redisTokenKey = null;
        if (StringUtils.isNotEmpty((CharSequence)token) && StringUtils.isNotEmpty((CharSequence)(tokenValue = this.redis.get(redisTokenKey = this.authProperties.getRedisTokenPrefix() + token)))) {
            this.redis.del(redisTokenKey);
        }
        token = UUID.randomUUID().toString();
        redisTokenKey = this.authProperties.getRedisTokenPrefix() + token;
        Integer tokenTimeout = this.authServiceProperties.getTokenTimeout();
        this.redis.set(redisTokenKey, JSONObject.toJSONString((Object)userInfo), (long)tokenTimeout.intValue());
        ServletUtils.addCookie((HttpServletResponse)this.response, (String)this.authProperties.getCookieTokenKey(), (String)token, (int)tokenTimeout);
        this.response.setHeader(this.authProperties.getCookieTokenKey(), token);
        return token;
    }

    public Result<?> logout() {
        String token = this.getRequestToken();
        if (StringUtils.isEmpty((CharSequence)token)) {
            return R.unauthorized();
        }
        this.redis.del(this.authProperties.getRedisTokenPrefix() + token);
        ServletUtils.addCookie((HttpServletResponse)this.response, (String)this.authProperties.getCookieTokenKey(), null, (int)0);
        return R.success();
    }
}

