/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.crypto.controller.key.exchange;

import ai.yue.library.base.annotation.api.version.ApiVersion;
import ai.yue.library.base.crypto.constant.key.exchange.ExchangeKeyEnum;
import ai.yue.library.base.crypto.dao.key.exchange.KeyExchangeStorage;
import ai.yue.library.base.util.IdUtils;
import ai.yue.library.base.validation.Validator;
import ai.yue.library.base.view.R;
import ai.yue.library.base.view.Result;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.asymmetric.AbstractAsymmetricCrypto;
import cn.hutool.crypto.asymmetric.KeyType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiVersion(value=2.3)
@RestController
@RequestMapping(value={"/open/{version}/keyExchange"})
public class KeyExchangeController {
    @Autowired
    private KeyExchangeStorage keyExchangeStorage;
    @Autowired
    private Validator validator;

    @PostMapping(value={"/{storageKey}"})
    public Result<?> getExchangeKey(@PathVariable String storageKey, ExchangeKeyEnum exchangeKeyType, @Nullable String encryptedClientPublicKey) {
        this.validator.param((Object)storageKey).uuid(storageKey);
        if (StrUtil.isEmpty((CharSequence)encryptedClientPublicKey)) {
            AbstractAsymmetricCrypto asymmetricCrypto = exchangeKeyType.getAsymmetricCrypto();
            this.keyExchangeStorage.setPrivateKeyBase64(storageKey, asymmetricCrypto.getPrivateKeyBase64());
            return R.success((Object)asymmetricCrypto.getPublicKeyBase64());
        }
        String privateKeyBase64 = this.keyExchangeStorage.getPrivateKeyBase64(storageKey);
        AbstractAsymmetricCrypto asymmetricCrypto = exchangeKeyType.getAsymmetricCrypto(privateKeyBase64, null);
        String clientPublicKey = asymmetricCrypto.decryptStr(encryptedClientPublicKey, KeyType.PrivateKey);
        AbstractAsymmetricCrypto clientAsymmetricCrypto = exchangeKeyType.getAsymmetricCrypto(null, clientPublicKey);
        String exchangeKey = IdUtils.getRandomCode((int)16);
        this.keyExchangeStorage.setExchangeKey(storageKey, exchangeKey);
        String clientPublicKeyEncryptExchangeKey = clientAsymmetricCrypto.encryptBase64(exchangeKey, KeyType.PublicKey);
        return R.success((Object)clientPublicKeyEncryptExchangeKey);
    }

    @PostMapping(value={"/{storageKey}/addAlias"})
    public Result<?> addAlias(@PathVariable String storageKey, String storageKeyAlias) {
        this.keyExchangeStorage.addAlias(storageKey, storageKeyAlias);
        return R.success();
    }
}

