/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.util;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class DateUtils {
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
    public static final DateTimeFormatter y_M_d_H_m_s = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
    public static final DateTimeFormatter y_M_d_H_m_s_S = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss:SSS");
    public static final DateTimeFormatter y_M_d = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter TODAY_START = DateTimeFormatter.ofPattern("yyyy-MM-dd 00:00:00");
    public static final DateTimeFormatter TODAY_END = DateTimeFormatter.ofPattern("yyyy-MM-dd 23:59:59");
    public static final DateTimeFormatter MONTH_START = DateTimeFormatter.ofPattern("yyyy-MM-01 00:00:00");

    public static boolean isBetween(String startTime, String dateTime, String endTime) {
        LocalDateTime end;
        LocalDateTime start = Timestamp.valueOf(startTime).toLocalDateTime();
        LocalDateTime time = Timestamp.valueOf(dateTime).toLocalDateTime();
        return time.isBefore(end = Timestamp.valueOf(endTime).toLocalDateTime()) && time.isAfter(start);
    }

    public static boolean isBetween(LocalDateTime startTime, LocalDateTime dateTime, LocalDateTime endTime) {
        return dateTime.isBefore(endTime) && dateTime.isAfter(startTime);
    }

    public static boolean isBetween(Date startTime, Date dateTime, Date endTime) {
        return dateTime.before(endTime) && dateTime.after(startTime);
    }

    public static Long getTimestamp() {
        return System.currentTimeMillis();
    }

    public static String get_y_M_d() {
        return y_M_d.format(LocalDate.now());
    }

    public static String get_y_M_d_H_m_s() {
        return y_M_d_H_m_s.format(LocalDateTime.now());
    }

    public static String getTodayStart() {
        return TODAY_START.format(LocalDateTime.now());
    }

    public static String getTodayEnd() {
        return TODAY_END.format(LocalDateTime.now());
    }

    public static String getWeekmorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.set(7, 2);
        return DateUtils.to_y_M_d_H_m_s(cal.getTimeInMillis());
    }

    public static String getWeeknight() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 23, 59, 59);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.set(7, 2);
        cal.add(7, 6);
        return DateUtils.to_y_M_d_H_m_s(cal.getTimeInMillis());
    }

    public static Long toTimestamp(String dateTime) {
        return Timestamp.valueOf(dateTime).getTime();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDateTime();
    }

    public static String to_y_M_d(long timestamp) {
        return y_M_d.format(LocalDate.ofEpochDay(timestamp));
    }

    public static String to_y_M_d(Date date) {
        return y_M_d.format(DateUtils.toLocalDateTime(date));
    }

    public static String to_y_M_d_H_m_s(long timestamp) {
        LocalDateTime localDateTime = DateUtils.toLocalDateTime(new Date(timestamp));
        return y_M_d_H_m_s.format(localDateTime);
    }

    public static String to_y_M_d_H_m_s(Date date) {
        return y_M_d_H_m_s.format(DateUtils.toLocalDateTime(date));
    }

    public static long dateDaysDifference(LocalDateTime startTime, LocalDateTime endTime) {
        return startTime.toLocalDate().toEpochDay() - endTime.toLocalDate().toEpochDay();
    }

    public static long dateDaysDifference(LocalDate startDate, LocalDate endDate) {
        return startDate.toEpochDay() - endDate.toEpochDay();
    }
}

