/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.config;

import ai.yue.library.base.config.argument.resolver.CustomArgumentResolversConfig;
import ai.yue.library.base.config.handler.ExceptionHandlerConfig;
import ai.yue.library.base.config.http.HttpsRequestFactory;
import ai.yue.library.base.config.http.RestProperties;
import ai.yue.library.base.config.properties.CorsProperties;
import ai.yue.library.base.config.thread.pool.AsyncConfig;
import ai.yue.library.base.util.ApplicationContextUtils;
import ai.yue.library.base.util.servlet.multipart.UploadProperties;
import ai.yue.library.base.validation.Validator;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@Import(value={ExceptionHandlerConfig.class, AsyncConfig.class, CustomArgumentResolversConfig.class, ApplicationContextUtils.class})
@EnableConfigurationProperties(value={RestProperties.class, CorsProperties.class, UploadProperties.class})
public class BeanAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(BeanAutoConfig.class);

    @Bean
    @ConditionalOnMissingBean
    public RestTemplate restTemplate(RestProperties restProperties) {
        Integer readTimeout;
        HttpsRequestFactory factory = new HttpsRequestFactory();
        Integer connectTimeout = restProperties.getConnectTimeout();
        if (connectTimeout != null) {
            factory.setConnectTimeout(connectTimeout);
        }
        if ((readTimeout = restProperties.getReadTimeout()) != null) {
            factory.setReadTimeout(readTimeout);
        }
        log.info("\u3010\u521d\u59cb\u5316\u914d\u7f6e-HTTPS\u5ba2\u6237\u7aef\u3011Bean\uff1aRestTemplate ... \u5df2\u521d\u59cb\u5316\u5b8c\u6bd5\u3002");
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="yue.cors", name={"allow"}, havingValue="true", matchIfMissing=true)
    public CorsFilter corsFilter(CorsProperties corsProperties) {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.setAllowedHeaders(Arrays.asList("*"));
        config.setAllowedMethods(Arrays.asList("*"));
        config.setAllowedOrigins(Arrays.asList("*"));
        config.setMaxAge(Long.valueOf(3600L));
        List<String> exposedHeaders = corsProperties.getExposedHeaders();
        if (exposedHeaders != null) {
            config.setExposedHeaders(exposedHeaders);
        } else {
            config.addExposedHeader("token");
        }
        source.registerCorsConfiguration("/**", config);
        log.info("\u3010\u521d\u59cb\u5316\u914d\u7f6e-\u8de8\u57df\u3011\u9ed8\u8ba4\u4efb\u4f55\u60c5\u51b5\u4e0b\u90fd\u5141\u8bb8\u8de8\u57df\u8bbf\u95ee ... \u5df2\u521d\u59cb\u5316\u5b8c\u6bd5\u3002");
        return new CorsFilter((CorsConfigurationSource)source);
    }

    @Bean
    @ConditionalOnMissingBean
    public Validator validator() {
        log.info("\u3010\u521d\u59cb\u5316\u914d\u7f6e-\u6821\u9a8c\u5668\u3011Bean\uff1aValidator ... \u5df2\u521d\u59cb\u5316\u5b8c\u6bd5\u3002");
        return new Validator();
    }
}

