/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class ArithCompute {
    private static final int DEF_DIV_SCALE = 10;

    public static double add(double augend, double ... addends) {
        BigDecimal bd_augend = new BigDecimal(Double.toString(augend));
        for (double addend : addends) {
            BigDecimal bd_addend = new BigDecimal(Double.toString(addend));
            bd_augend = bd_augend.add(bd_addend);
        }
        return bd_augend.doubleValue();
    }

    public static double sub(double minuend, double ... subtrahends) {
        BigDecimal bd_minuend = new BigDecimal(Double.toString(minuend));
        for (double subtrahend : subtrahends) {
            BigDecimal bd_subtrahend = new BigDecimal(Double.toString(subtrahend));
            bd_minuend = bd_minuend.subtract(bd_subtrahend);
        }
        return bd_minuend.doubleValue();
    }

    public static double mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static double div(double v1, double v2) {
        return ArithCompute.div(v1, v2, 10);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("\u7cbe\u786e\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, RoundingMode.HALF_UP).doubleValue();
    }

    public static double round(double v, int scale) {
        return ArithCompute.roundingMode(v, scale, RoundingMode.HALF_UP);
    }

    public static double roundingMode(double v, int scale, RoundingMode roundingMode) {
        if (scale < 0) {
            throw new IllegalArgumentException("\u7cbe\u786e\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, roundingMode).doubleValue();
    }

    public static double centToYuan(int moneySumCent) {
        return ArithCompute.div(moneySumCent, 100.0);
    }

    public static int yuanToCent(double moneySum) {
        return Integer.parseInt(Double.toString(ArithCompute.mul(moneySum, 100.0)));
    }
}

