/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.convert;

import ai.yue.library.base.convert.converter.JSONArrayConverter;
import ai.yue.library.base.convert.converter.JSONObjectConverter;
import ai.yue.library.base.util.ListUtils;
import ai.yue.library.base.util.MapUtils;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.convert.ConverterRegistry;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Convert
extends cn.hutool.core.convert.Convert {
    private static final Logger log = LoggerFactory.getLogger(Convert.class);

    public static <T> T convertByClassName(String className, Object value) throws ConvertException {
        return (T)cn.hutool.core.convert.Convert.convertByClassName((String)className, (Object)value);
    }

    @Deprecated
    public static <T> T convert(Class<T> type, Object value) throws ConvertException {
        return (T)cn.hutool.core.convert.Convert.convert(type, (Object)value);
    }

    public static <T> T convert(TypeReference<T> reference, Object value) throws ConvertException {
        return (T)cn.hutool.core.convert.Convert.convert(reference, (Object)value);
    }

    public static <T> T convert(Type type, Object value) throws ConvertException {
        return (T)cn.hutool.core.convert.Convert.convert((Type)type, (Object)value);
    }

    public static <T> T convert(Class<T> type, Object value, T defaultValue) throws ConvertException {
        return (T)cn.hutool.core.convert.Convert.convert(type, (Object)value, defaultValue);
    }

    public static <T> T convert(Type type, Object value, T defaultValue) throws ConvertException {
        return (T)cn.hutool.core.convert.Convert.convert((Type)type, (Object)value, defaultValue);
    }

    public static <T> T convertQuietly(Type type, Object value) {
        return (T)cn.hutool.core.convert.Convert.convertQuietly((Type)type, (Object)value);
    }

    public static <T> T convertQuietly(Type type, Object value, T defaultValue) {
        return (T)cn.hutool.core.convert.Convert.convertQuietly((Type)type, (Object)value, defaultValue);
    }

    public static <T> T convert(Object value, Class<T> clazz) {
        return Convert.toObject(value, clazz);
    }

    public static <T> T toObject(Object value, Class<T> clazz) {
        if (value != null && clazz != null && (clazz == value.getClass() || clazz.isInstance(value))) {
            return (T)value;
        }
        if (value != null && value instanceof String) {
            String str = (String)value;
            if (clazz == LocalDate.class) {
                return (T)LocalDate.parse(str);
            }
            if (clazz == LocalDateTime.class) {
                return (T)LocalDateTime.parse(str);
            }
        }
        if (clazz == JSONObject.class) {
            return (T)Convert.toJSONObject(value);
        }
        if (clazz == JSONArray.class) {
            return (T)Convert.toJSONArray(value);
        }
        try {
            return (T)TypeUtils.cast((Object)value, clazz, (ParserConfig)ParserConfig.getGlobalInstance());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("\u3010Convert\u3011\u91c7\u7528 fastjson \u7c7b\u578b\u8f6c\u6362\u5668\u8f6c\u6362\u5931\u8d25\uff0c\u6b63\u5c1d\u8bd5 hutool \u7c7b\u578b\u8f6c\u6362\u5668\u8f6c\u6362\u3002");
                e.printStackTrace();
            }
            return (T)cn.hutool.core.convert.Convert.convert(clazz, (Object)value);
        }
    }

    public static <T> T toJavaBean(Object value, Class<T> clazz) {
        if (value != null && clazz != null && (clazz == value.getClass() || clazz.isInstance(value))) {
            return (T)value;
        }
        try {
            if (value instanceof String) {
                return (T)JSONObject.parseObject((String)((String)value), clazz);
            }
            return (T)TypeUtils.castToJavaBean((Map)Convert.toJSONObject(value), clazz, (ParserConfig)ParserConfig.getGlobalInstance());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("\u3010Convert\u3011\u91c7\u7528 fastjson \u7c7b\u578b\u8f6c\u6362\u5668\u8f6c\u6362\u5931\u8d25\uff0c\u6b63\u5c1d\u8bd5 hutool \u7c7b\u578b\u8f6c\u6362\u5668\u8f6c\u6362\u3002");
                e.printStackTrace();
            }
            return (T)BeanUtil.toBean((Object)value, clazz);
        }
    }

    public static JSONObject toJSONObject(Object value) {
        if (value instanceof JSONObject) {
            return (JSONObject)value;
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value);
        }
        if (value instanceof String) {
            return JSONObject.parseObject((String)((String)value));
        }
        return JSONObject.parseObject((String)JSONObject.toJSONString((Object)value));
    }

    public static JSONArray toJSONArray(Object value) {
        if (value instanceof JSONArray) {
            return (JSONArray)value;
        }
        if (value instanceof List) {
            return new JSONArray((List)value);
        }
        if (value instanceof String) {
            return JSONArray.parseArray((String)((String)value));
        }
        return (JSONArray)JSON.toJSON((Object)value);
    }

    public static <T> ArrayList<T> toList(T[] array) {
        return ListUtils.toList(array);
    }

    public static <T> List<T> toList(JSONArray jsonArray, Class<T> clazz) {
        return ListUtils.toList(jsonArray, clazz);
    }

    public static <T> List<T> toList(List<JSONObject> list, Class<T> clazz) {
        return ListUtils.toList(list, clazz);
    }

    public static List<String> toList(List<JSONObject> list, String keepKey) {
        return ListUtils.toList(list, keepKey);
    }

    public static <T> List<T> toList(List<JSONObject> list, String keepKey, Class<T> clazz) {
        return ListUtils.toList(list, keepKey, clazz);
    }

    public static List<String> toListAndDistinct(List<JSONObject> list, String keepKey) {
        return ListUtils.toListAndDistinct(list, keepKey);
    }

    public static <T> List<T> toListAndDistinct(List<JSONObject> list, String keepKey, Class<T> clazz) {
        return ListUtils.toListAndDistinct(list, keepKey, clazz);
    }

    public static List<JSONObject> toJsonList(List<Map<String, Object>> list) {
        return ListUtils.toJsonList(list);
    }

    public static List<JSONObject> toJsonList(JSONArray jsonArray) {
        return ListUtils.toJsonList(jsonArray);
    }

    public static <T> List<JSONObject> toJsonListT(List<T> list) {
        return ListUtils.toJsonListT(list);
    }

    public static JSONObject[] toJsons(JSONArray jsonArray) {
        return ListUtils.toJsons(jsonArray);
    }

    public static JSONObject[] toJsons(List<JSONObject> list) {
        return ListUtils.toJsons(list);
    }

    public static <T> JSONObject[] toJsonsT(List<T> list) {
        return ListUtils.toJsonsT(list);
    }

    public static <T> JSONObject[] toJsonsTAndRemoveEmpty(List<T> list) {
        return ListUtils.toJsonsTAndRemoveEmpty(list);
    }

    public static JSONObject[] toJsons(String jsonString) {
        return ListUtils.toJsons(jsonString);
    }

    public static JSONObject[] toJsons(String text, String regex, String key) {
        return ListUtils.toJsons(text, regex, key);
    }

    public static String toUnderlineCase(CharSequence str) {
        return StrUtil.toUnderlineCase((CharSequence)str);
    }

    public static String toSymbolCase(CharSequence str, char symbol) {
        return StrUtil.toSymbolCase((CharSequence)str, (char)symbol);
    }

    public static String toCamelCase(CharSequence name) {
        return StrUtil.toCamelCase((CharSequence)name);
    }

    public static JSONObject toCamelCase(Object param) {
        return MapUtils.toCamelCase(param);
    }

    public static JSONObject toUnderlineCase(Object param) {
        return MapUtils.toUnderlineCase(param);
    }

    public static JSONObject toSnakeCase(Object param) {
        return MapUtils.toSnakeCase(param);
    }

    public static JSONObject toPropertyNamingStrategy(Object param, PropertyNamingStrategy propertyNamingStrategy) {
        return MapUtils.toPropertyNamingStrategy(param, propertyNamingStrategy);
    }

    public static List<JSONObject> toSnakeCaseJsonList(List<JSONObject> list) {
        return ListUtils.toSnakeCaseJsonList(list);
    }

    public static <T> List<JSONObject> toSnakeCaseJsonListT(List<T> list) {
        return ListUtils.toSnakeCaseJsonListT(list);
    }

    public static List<JSONObject> toUnderlineCaseJsonList(List<JSONObject> list) {
        return ListUtils.toUnderlineCaseJsonList(list);
    }

    public static <T> List<JSONObject> toUnderlineCaseJsonListT(List<T> list) {
        return ListUtils.toUnderlineCaseJsonListT(list);
    }

    public static List<JSONObject> toCamelCaseJsonList(List<JSONObject> list) {
        return ListUtils.toCamelCaseJsonList(list);
    }

    public static <T> List<JSONObject> toCamelCaseJsonListT(List<T> list) {
        return ListUtils.toCamelCaseJsonListT(list);
    }

    static {
        ConverterRegistry converterRegistry = ConverterRegistry.getInstance();
        converterRegistry.putCustom(JSONObject.class, JSONObjectConverter.class);
        converterRegistry.putCustom(JSONArray.class, JSONArrayConverter.class);
    }
}

