/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.util;

import ai.yue.library.base.exception.ParamException;
import ai.yue.library.base.exception.ParamVoidException;
import ai.yue.library.base.exception.ResultException;
import ai.yue.library.base.ipo.ParamFormatIPO;
import ai.yue.library.base.util.MapUtils;
import ai.yue.library.base.util.ObjectUtils;
import ai.yue.library.base.util.SpringUtils;
import ai.yue.library.base.util.StringUtils;
import ai.yue.library.base.view.R;
import ai.yue.library.base.webenv.WebEnv;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ParamUtils {
    private static final String PARAM_PREFIX_MUST = "\u3010\u5fc5\u4f20\u53c2\u6570\u3011\uff1a";
    private static final String PARAM_PREFIX_CAN = "\u3010\u53ef\u9009\u53c2\u6570\u3011\uff1a";
    private static final String PARAM_PREFIX_RECEIVED = "\u3010\u6536\u5230\u4f20\u53c2\u3011\uff1a";

    public static JSONObject getParam() {
        WebEnv webEnv = SpringUtils.getBean(WebEnv.class);
        return webEnv.getParam();
    }

    public static <T> T getParam(Class<T> clazz) {
        WebEnv webEnv = SpringUtils.getBean(WebEnv.class);
        return webEnv.getParam(clazz);
    }

    public static void paramFormatBoolean(JSONObject paramJson, String ... keys) {
        for (String key : keys) {
            paramJson.replace((Object)key, (Object)paramJson.getBoolean(key));
        }
    }

    public static void paramFormatBigDecimal(JSONObject paramJson, String ... keys) {
        for (String key : keys) {
            paramJson.replace((Object)key, (Object)paramJson.getBigDecimal(key));
        }
    }

    public static void paramFormatJSONObject(JSONObject paramJson, String ... keys) {
        for (String key : keys) {
            paramJson.replace((Object)key, (Object)paramJson.getJSONObject(key));
        }
    }

    public static void paramFormatJSONArray(JSONObject paramJson, String ... keys) {
        for (String key : keys) {
            paramJson.replace((Object)key, (Object)paramJson.getJSONArray(key));
        }
    }

    public static void paramFormatObject(JSONObject paramJson, List<ParamFormatIPO> paramFormatIPOList) {
        for (ParamFormatIPO paramFormatIPO : paramFormatIPOList) {
            String key = paramFormatIPO.getKey();
            Class<?> clazz = paramFormatIPO.getClazz();
            paramJson.replace((Object)key, paramJson.getObject(key, clazz));
        }
    }

    public static void paramFormat(JSONObject paramJson, String[] booleanKeys, String[] decimalKeys, String[] jsonObjectKeys, String[] jsonArrayKeys) {
        if (!StringUtils.isEmptys(booleanKeys)) {
            ParamUtils.paramFormatBoolean(paramJson, booleanKeys);
        }
        if (!StringUtils.isEmptys(decimalKeys)) {
            ParamUtils.paramFormatBigDecimal(paramJson, decimalKeys);
        }
        if (!StringUtils.isEmptys(jsonObjectKeys)) {
            ParamUtils.paramFormatJSONObject(paramJson, jsonObjectKeys);
        }
        if (!StringUtils.isEmptys(jsonArrayKeys)) {
            ParamUtils.paramFormatJSONArray(paramJson, jsonArrayKeys);
        }
    }

    public static void paramValidate(Object ... objects) {
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (!ObjectUtils.isNull((Object)object)) continue;
            throw new ResultException(R.paramCheckNotPass());
        }
    }

    public static void paramValidate(JSONObject paramJson, String[] mustContainKeys, String ... canContainKeys) {
        boolean isHint = false;
        String hintMsg = "";
        if (!MapUtils.isKeys((Map<String, Object>)paramJson, mustContainKeys, canContainKeys)) {
            isHint = true;
            hintMsg = "\u3010\u9519\u8bef\u63d0\u793a\u3011\uff1a\u8981\u6c42\u7684\u53c2\u6570key\u4e0d\u4e00\u81f4\uff0c";
        }
        if (!isHint) {
            for (String key : mustContainKeys) {
                if (!StringUtils.isEmptyIfStr((Object)paramJson.get((Object)key))) continue;
                isHint = true;
                hintMsg = StrUtil.format((CharSequence)"\u3010\u9519\u8bef\u63d0\u793a\u3011\uff1a\u5fc5\u4f20\u53c2\u6570 {} \u7684\u503c\u4e3a\u7a7a\uff0c", (Object[])new Object[]{key});
                break;
            }
        }
        if (isHint) {
            StringBuffer paramHint = new StringBuffer();
            paramHint.append(hintMsg);
            paramHint.append(PARAM_PREFIX_MUST + Arrays.toString(mustContainKeys));
            paramHint.append("\uff0c");
            paramHint.append(PARAM_PREFIX_CAN + Arrays.toString(canContainKeys));
            paramHint.append("\uff0c");
            paramHint.append(PARAM_PREFIX_RECEIVED + paramJson.keySet());
            throw new ParamException(paramHint.toString());
        }
    }

    public static void paramValidate(List<JSONObject> paramList, String[] mustContainKeys, String ... canContainKeys) {
        if (paramList.isEmpty()) {
            throw new ParamVoidException();
        }
        for (JSONObject paramJson : paramList) {
            ParamUtils.paramValidate(paramJson, mustContainKeys, canContainKeys);
        }
    }

    public static String cellphoneEncrypt(String cellphone) {
        if (cellphone.length() == 11) {
            return cellphone.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
        }
        if (cellphone.length() > 4) {
            return cellphone.replaceAll("(\\d{2})\\d+(\\d{2})", "$1****$2");
        }
        return cellphone.replaceAll("(\\d{1})\\d+(\\d{1})", "$1**$2");
    }
}

