/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.config.net.proxy;

import ai.yue.library.base.config.net.proxy.NetProxyProperties;
import cn.hutool.core.util.StrUtil;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={NetProxyProperties.class})
@ConditionalOnProperty(prefix="yue.net.proxy", name={"enabled"}, havingValue="true")
public class NetProxy {
    private static final Logger log = LoggerFactory.getLogger(NetProxy.class);
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTPS_PROXY_HOST = "https.proxyHost";
    public static final String HTTPS_PROXY_PORT = "https.proxyPort";
    public static final String FTP_PROXY_HOST = "ftp.proxyHost";
    public static final String FTP_PROXY_PORT = "ftp.proxyPort";
    public static final String SOCKS_PROXY_HOST = "socksProxyHost";
    public static final String SOCKS_PROXY_PORT = "socksProxyPort";
    public static final String SOCKS_PROXY_VERSION = "socksProxyVersion";
    public static final String FTP_NON_PROXY_HOSTS = "ftp.nonProxyHosts";
    public static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    public static final String SOCKET_NON_PROXY_HOSTS = "socksNonProxyHosts";
    public static final String USE_SYSTEM_PROXIES = "java.net.useSystemProxies";
    public static final String DEF_NON_PROXY_VAL = "localhost|127.*|[::1]|0.0.0.0|[::0]";
    public static final String ADD_NON_PROXY_VAL = "10.*|172.16.*|172.17.*|172.18.*|172.19.*|172.20.*|172.21.*|172.22.*|172.23.*|172.24.*|172.25.*|172.26.*|172.27.*|172.28.*|172.29.*|172.30.*|172.31.*|192.168.*";
    @Autowired
    NetProxyProperties netProxyProperties;

    public static void useSystemProxies() {
        System.setProperty(USE_SYSTEM_PROXIES, "true");
    }

    @PostConstruct
    private void init() {
        String basicAuthenticatorUsername = this.netProxyProperties.getBasicAuthenticatorUsername();
        String basicAuthenticatorPassword = this.netProxyProperties.getBasicAuthenticatorPassword();
        if (StrUtil.isNotEmpty((CharSequence)basicAuthenticatorUsername) && StrUtil.isNotEmpty((CharSequence)basicAuthenticatorPassword)) {
            Authenticator.setDefault(new BasicAuthenticator(basicAuthenticatorUsername, basicAuthenticatorPassword));
        }
        if (this.netProxyProperties.isHttpServerEnabled()) {
            this.httpServerEnable();
        }
        if (this.netProxyProperties.isHttpsServerEnabled()) {
            this.httpsServerEnable();
        }
        if (this.netProxyProperties.isFtpServerEnabled()) {
            this.ftpServerEnable();
        }
        if (this.netProxyProperties.isSocksServerEnabled()) {
            this.socksServerEnable();
        }
        String nonProxyHosts = this.netProxyProperties.getNonProxyHosts();
        String nonProxyHostsAdditional = this.netProxyProperties.getNonProxyHostsAdditional();
        if (StrUtil.isNotEmpty((CharSequence)nonProxyHosts) && nonProxyHosts.contains(",")) {
            nonProxyHosts = nonProxyHosts.replace(",", "|");
        }
        if (StrUtil.isNotEmpty((CharSequence)nonProxyHostsAdditional)) {
            if (nonProxyHostsAdditional.contains(",")) {
                nonProxyHostsAdditional = nonProxyHostsAdditional.replace(",", "|");
            }
            nonProxyHosts = String.join((CharSequence)"|", nonProxyHosts, nonProxyHostsAdditional);
        }
        System.setProperty(HTTP_NON_PROXY_HOSTS, nonProxyHosts);
        System.setProperty(FTP_NON_PROXY_HOSTS, nonProxyHosts);
        System.setProperty(SOCKET_NON_PROXY_HOSTS, nonProxyHosts);
        log.info("\u3010\u521d\u59cb\u5316\u914d\u7f6e-\u5168\u5c40\u7f51\u7edc\u4ee3\u7406\u3011Java\u5168\u5c40\u7f51\u7edc\u4ee3\u7406\u5df2\u5f00\u542f\uff0c\u5df2\u77e5\u4e0d\u4f1a\u91c7\u7528Java\u5168\u5c40\u7f51\u7edc\u4ee3\u7406\u8fdb\u884c\u901a\u4fe1\u7684\u4e09\u65b9\u5e93\u6709\uff1aaliyun-java-sdk-core ...");
    }

    public void httpServerEnable() {
        System.setProperty(HTTP_PROXY_HOST, this.netProxyProperties.getHttpServerHost());
        System.setProperty(HTTP_PROXY_PORT, String.valueOf(this.netProxyProperties.getHttpServerPort()));
        log.info("\u3010\u5168\u5c40\u7f51\u7edc\u4ee3\u7406\u3011\u5df2\u542f\u7528http\u4ee3\u7406\u670d\u52a1\u5668\u8fdb\u884chttp\u8bf7\u6c42\u4ee3\u7406\u8bbf\u95ee ...");
    }

    public void httpServerClose() {
        System.clearProperty(HTTP_PROXY_HOST);
        log.info("\u3010\u5168\u5c40\u7f51\u7edc\u4ee3\u7406\u3011\u5df2\u65ad\u5f00http\u4ee3\u7406\u670d\u52a1\u5668\uff0chttp\u8bf7\u6c42\u5c06\u4e0d\u518d\u8fdb\u884c\u4ee3\u7406\u8bbf\u95ee ...");
    }

    public void httpsServerEnable() {
        System.setProperty(HTTPS_PROXY_HOST, this.netProxyProperties.getHttpsServerHost());
        System.setProperty(HTTPS_PROXY_PORT, String.valueOf(this.netProxyProperties.getHttpsServerPort()));
        log.info("\u3010\u5168\u5c40\u7f51\u7edc\u4ee3\u7406\u3011\u5df2\u542f\u7528https\u4ee3\u7406\u670d\u52a1\u5668\u8fdb\u884chttps\u8bf7\u6c42\u4ee3\u7406\u8bbf\u95ee ...");
    }

    public void httpsServerClose() {
        System.clearProperty(HTTPS_PROXY_HOST);
        log.info("\u3010\u5168\u5c40\u7f51\u7edc\u4ee3\u7406\u3011\u5df2\u65ad\u5f00https\u4ee3\u7406\u670d\u52a1\u5668\uff0chttps\u8bf7\u6c42\u5c06\u4e0d\u518d\u8fdb\u884c\u4ee3\u7406\u8bbf\u95ee ...");
    }

    public void ftpServerEnable() {
        System.setProperty(FTP_PROXY_HOST, this.netProxyProperties.getFtpServerHost());
        System.setProperty(FTP_PROXY_PORT, String.valueOf(this.netProxyProperties.getFtpServerPort()));
        log.info("\u3010\u5168\u5c40\u7f51\u7edc\u4ee3\u7406\u3011\u5df2\u542f\u7528ftp\u4ee3\u7406\u670d\u52a1\u5668\u8fdb\u884cftp\u8bf7\u6c42\u4ee3\u7406\u8bbf\u95ee ...");
    }

    public void ftpServerClose() {
        System.clearProperty(FTP_PROXY_HOST);
        log.info("\u3010\u5168\u5c40\u7f51\u7edc\u4ee3\u7406\u3011\u5df2\u65ad\u5f00ftp\u4ee3\u7406\u670d\u52a1\u5668\uff0cftp\u8bf7\u6c42\u5c06\u4e0d\u518d\u8fdb\u884c\u4ee3\u7406\u8bbf\u95ee ...");
    }

    public void socksServerEnable() {
        System.setProperty(SOCKS_PROXY_HOST, this.netProxyProperties.getSocksServerHost());
        System.setProperty(SOCKS_PROXY_PORT, String.valueOf(this.netProxyProperties.getSocksServerPort()));
        System.setProperty(SOCKS_PROXY_VERSION, String.valueOf(this.netProxyProperties.getSocksProxyVersion()));
        log.info("\u3010\u5168\u5c40\u7f51\u7edc\u4ee3\u7406\u3011\u5df2\u542f\u7528socks\u4ee3\u7406\u670d\u52a1\u5668\u8fdb\u884chttp\u3001https\u3001ftp\u3001socket\u8bf7\u6c42\u4ee3\u7406\u8bbf\u95ee ...");
    }

    public void socksServerClose() {
        System.clearProperty(SOCKS_PROXY_HOST);
        log.info("\u3010\u5168\u5c40\u7f51\u7edc\u4ee3\u7406\u3011\u5df2\u65ad\u5f00socks\u4ee3\u7406\u670d\u52a1\u5668\uff0chttp\u3001https\u3001ftp\u3001socket\u8bf7\u6c42\u5c06\u4e0d\u518d\u8fdb\u884c\u4ee3\u7406\u8bbf\u95ee ...");
    }

    static class BasicAuthenticator
    extends Authenticator {
        private String user = "";
        private String password = "";

        public BasicAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password.toCharArray());
        }
    }
}

