/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.util;

import cn.hutool.core.date.DateUtil;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;

public class DateUtils
extends DateUtil {
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
    public static final DateTimeFormatter DATE_TIME_KEEP_MS_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss:SSS");
    public static final DateTimeFormatter TODAY_START_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd 00:00:00");
    public static final DateTimeFormatter TODAY_END_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd 23:59:59");
    public static final DateTimeFormatter MONTH_START_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-01 00:00:00");

    public static boolean isBetween(String startTime, String dateTime, String endTime) {
        LocalDateTime end;
        LocalDateTime start = Timestamp.valueOf(startTime).toLocalDateTime();
        LocalDateTime time = Timestamp.valueOf(dateTime).toLocalDateTime();
        return time.isBefore(end = Timestamp.valueOf(endTime).toLocalDateTime()) && time.isAfter(start);
    }

    public static boolean isBetween(LocalDateTime startTime, LocalDateTime dateTime, LocalDateTime endTime) {
        return dateTime.isBefore(endTime) && dateTime.isAfter(startTime);
    }

    public static boolean isBetween(Date startTime, Date dateTime, Date endTime) {
        return dateTime.before(endTime) && dateTime.after(startTime);
    }

    public static long getTimestamp() {
        return System.currentTimeMillis();
    }

    public static long getTimestamp(int offsetMillis) {
        return DateUtils.getTimestamp() + (long)offsetMillis;
    }

    public static String getDateFormatter() {
        return DATE_FORMATTER.format(LocalDate.now());
    }

    public static String getDatetimeFormatter() {
        return DATE_TIME_FORMATTER.format(LocalDateTime.now());
    }

    public static String getTodayStartFormatter() {
        return TODAY_START_FORMATTER.format(LocalDateTime.now());
    }

    public static String getTodayEndFormatter() {
        return TODAY_END_FORMATTER.format(LocalDateTime.now());
    }

    public static String getWeekmorningFormatter() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.set(7, 2);
        return DateUtils.toDateTimeFormatter(cal.getTimeInMillis());
    }

    public static String getWeeknight() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 23, 59, 59);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.set(7, 2);
        cal.add(7, 6);
        return DateUtils.toDateTimeFormatter(cal.getTimeInMillis());
    }

    public static Long toTimestamp(String dateTime) {
        return Timestamp.valueOf(dateTime).getTime();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDateTime();
    }

    public static String toDateFormatter(long timestamp) {
        return DATE_FORMATTER.format(LocalDate.ofEpochDay(timestamp));
    }

    public static String toDateFormatter(Date date) {
        return DATE_FORMATTER.format(DateUtils.toLocalDateTime(date));
    }

    public static String toDateFormatter(TemporalAccessor date) {
        return DATE_FORMATTER.format(date);
    }

    public static String toDateTimeFormatter(long timestamp) {
        LocalDateTime localDateTime = DateUtils.toLocalDateTime(new Date(timestamp));
        return DATE_TIME_FORMATTER.format(localDateTime);
    }

    public static String toDateTimeFormatter(Date date) {
        return DATE_TIME_FORMATTER.format(DateUtils.toLocalDateTime(date));
    }

    public static String toDateTimeFormatter(TemporalAccessor date) {
        return DATE_TIME_FORMATTER.format(date);
    }

    @Deprecated
    public static String to_y_M_d_H_m_s(TemporalAccessor date) {
        return DATE_TIME_FORMATTER.format(date);
    }

    public static long dateDaysDifference(LocalDateTime startTime, LocalDateTime endTime) {
        return startTime.toLocalDate().toEpochDay() - endTime.toLocalDate().toEpochDay();
    }

    public static long dateDaysDifference(LocalDate startDate, LocalDate endDate) {
        return startDate.toEpochDay() - endDate.toEpochDay();
    }
}

