/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.config.thread.pool;

import ai.yue.library.base.config.thread.pool.AsyncProperties;
import ai.yue.library.base.config.thread.pool.ContextAwareAsyncExecutor;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;

@EnableAsync
@Configuration
@EnableConfigurationProperties(value={AsyncProperties.class})
@ConditionalOnProperty(prefix="yue.thread-pool.async", name={"enabled"}, havingValue="true")
public class AsyncConfig
implements AsyncConfigurer {
    private static final Logger log = LoggerFactory.getLogger(AsyncConfig.class);
    @Autowired
    AsyncProperties asyncProperties;

    @PostConstruct
    private void init() {
        log.info("\u3010\u521d\u59cb\u5316\u914d\u7f6e-\u5f02\u6b65\u7ebf\u7a0b\u6c60\u3011\u5f02\u6b65\u7ebf\u7a0b\u6c60\u914d\u7f6e\u5df2\u52a0\u8f7d\uff0c\u5f85\u4f7f\u7528\u65f6\u521d\u59cb\u5316 ...");
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new AsyncUncaughtExceptionHandler(){

            public void handleUncaughtException(Throwable arg0, Method arg1, Object ... arg2) {
                log.error("=========================={}=======================", (Object)arg0.getMessage(), (Object)arg0);
                log.error("exception method: {}", (Object)arg1.getName());
                for (Object param : arg2) {
                    log.error("Parameter value - {}", param);
                }
            }
        };
    }

    public Executor getAsyncExecutor() {
        ContextAwareAsyncExecutor executor = new ContextAwareAsyncExecutor();
        executor.setThreadNamePrefix(this.asyncProperties.getThreadNamePrefix());
        executor.setCorePoolSize(this.asyncProperties.getCorePoolSize());
        executor.setMaxPoolSize(this.asyncProperties.getMaxPoolSize());
        executor.setKeepAliveSeconds(this.asyncProperties.getKeepAliveSeconds());
        executor.setQueueCapacity(this.asyncProperties.getQueueCapacity());
        executor.setAllowCoreThreadTimeOut(this.asyncProperties.getAllowCoreThreadTimeOut());
        executor.setWaitForTasksToCompleteOnShutdown(this.asyncProperties.getWaitForTasksToCompleteOnShutdown());
        executor.setAwaitTerminationSeconds(this.asyncProperties.getAwaitTerminationSeconds());
        executor.setRejectedExecutionHandler(this.asyncProperties.getRejectedExecutionHandlerPolicy().getRejectedExecutionHandler());
        executor.initialize();
        log.info("\u3010\u521d\u59cb\u5316\u914d\u7f6e-\u5f02\u6b65\u7ebf\u7a0b\u6c60\u3011\u5171\u7528\u7236\u7ebf\u7a0b\u4e0a\u4e0b\u6587\u73af\u5883\uff0c\u5f02\u6b65\u6267\u884c\u4efb\u52a1\u65f6\u4e0d\u4e22\u5931token ... \u5df2\u521d\u59cb\u5316\u5b8c\u6bd5\u3002");
        return executor;
    }
}

