/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.ipo;

import com.alibaba.fastjson.JSONObject;

public class LocationIPO {
    double lng;
    double lat;

    public static LocationIPO toLocationIPO(JSONObject location) {
        double lng = location.getDouble("lng");
        double lat = location.getDouble("lat");
        return LocationIPO.builder().lng(lng).lat(lat).build();
    }

    public static LocationIPOBuilder builder() {
        return new LocationIPOBuilder();
    }

    public double getLng() {
        return this.lng;
    }

    public double getLat() {
        return this.lat;
    }

    public void setLng(double lng) {
        this.lng = lng;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocationIPO)) {
            return false;
        }
        LocationIPO other = (LocationIPO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLng(), other.getLng()) != 0) {
            return false;
        }
        return Double.compare(this.getLat(), other.getLat()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof LocationIPO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lng = Double.doubleToLongBits(this.getLng());
        result = result * 59 + (int)($lng >>> 32 ^ $lng);
        long $lat = Double.doubleToLongBits(this.getLat());
        result = result * 59 + (int)($lat >>> 32 ^ $lat);
        return result;
    }

    public String toString() {
        return "LocationIPO(lng=" + this.getLng() + ", lat=" + this.getLat() + ")";
    }

    public LocationIPO() {
    }

    public LocationIPO(double lng, double lat) {
        this.lng = lng;
        this.lat = lat;
    }

    public static class LocationIPOBuilder {
        private double lng;
        private double lat;

        LocationIPOBuilder() {
        }

        public LocationIPOBuilder lng(double lng) {
            this.lng = lng;
            return this;
        }

        public LocationIPOBuilder lat(double lat) {
            this.lat = lat;
            return this;
        }

        public LocationIPO build() {
            return new LocationIPO(this.lng, this.lat);
        }

        public String toString() {
            return "LocationIPO.LocationIPOBuilder(lng=" + this.lng + ", lat=" + this.lat + ")";
        }
    }
}

