/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.view;

import ai.yue.library.base.exception.ApiVersionDeprecatedException;
import ai.yue.library.base.exception.AttackException;
import ai.yue.library.base.exception.AuthorizeException;
import ai.yue.library.base.exception.ClientFallbackException;
import ai.yue.library.base.exception.DbException;
import ai.yue.library.base.exception.ForbiddenException;
import ai.yue.library.base.exception.LoginException;
import ai.yue.library.base.exception.ParamDecryptException;
import ai.yue.library.base.exception.ParamException;
import ai.yue.library.base.exception.ParamVoidException;
import ai.yue.library.base.exception.ResultException;
import ai.yue.library.base.util.ExceptionUtils;
import ai.yue.library.base.view.Result;
import ai.yue.library.base.view.ResultEnum;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.exceptions.ValidateException;
import cn.hutool.core.lang.Console;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.web.server.ResponseStatusException;

public class R {
    private static final Logger log = LoggerFactory.getLogger(R.class);

    private static Result<?> error(Integer code, String msg) {
        return Result.builder().code(code).msg(msg).flag(false).build();
    }

    private static <T> Result<T> error(Integer code, String msg, T data) {
        return new Result().toBuilder().code(code).msg(msg).flag(false).data(data).build();
    }

    private static Result<?> success(Integer code, String msg) {
        return Result.builder().code(code).msg(msg).flag(true).build();
    }

    public static Result<?> success() {
        return R.success(ResultEnum.SUCCESS.getCode(), ResultEnum.SUCCESS.getMsg());
    }

    public static <T> Result<T> success(T data) {
        return new Result().toBuilder().code(ResultEnum.SUCCESS.getCode()).msg(ResultEnum.SUCCESS.getMsg()).flag(true).data(data).build();
    }

    public static <T> Result<T> success(Long count, T data) {
        Result<T> result = new Result<T>(ResultEnum.SUCCESS.getCode(), ResultEnum.SUCCESS.getMsg(), true, count, data);
        return result;
    }

    public static <T> Result<T> success(Integer code, Long count, T data) {
        Result<T> result = new Result<T>(code, ResultEnum.SUCCESS.getMsg(), true, count, data);
        return result;
    }

    public static Result<?> loggedIn() {
        return R.success(ResultEnum.LOGGED_IN.getCode(), ResultEnum.LOGGED_IN.getMsg());
    }

    public static Result<?> resourceAlreadyInvalid() {
        return R.error(ResultEnum.RESOURCE_ALREADY_INVALID.getCode(), ResultEnum.RESOURCE_ALREADY_INVALID.getMsg());
    }

    public static Result<?> movedPermanently() {
        return R.error(ResultEnum.MOVED_PERMANENTLY.getCode(), ResultEnum.MOVED_PERMANENTLY.getMsg());
    }

    public static Result<?> fileEmpty() {
        return R.error(ResultEnum.FILE_EMPTY.getCode(), ResultEnum.FILE_EMPTY.getMsg());
    }

    public static Result<?> unauthorized() {
        return R.error(ResultEnum.UNAUTHORIZED.getCode(), ResultEnum.UNAUTHORIZED.getMsg());
    }

    public static Result<?> attack() {
        return R.error(ResultEnum.ATTACK.getCode(), ResultEnum.ATTACK.getMsg());
    }

    public static <T> Result<T> attack(T data) {
        return R.error(ResultEnum.ATTACK.getCode(), ResultEnum.ATTACK.getMsg(), data);
    }

    public static Result<?> forbidden() {
        return R.error(ResultEnum.FORBIDDEN.getCode(), ResultEnum.FORBIDDEN.getMsg());
    }

    public static Result<?> notFound() {
        return R.error(ResultEnum.NOT_FOUND.getCode(), ResultEnum.NOT_FOUND.getMsg());
    }

    public static <T> Result<T> methodNotAllowed(T data) {
        return R.error(ResultEnum.METHOD_NOT_ALLOWED.getCode(), ResultEnum.METHOD_NOT_ALLOWED.getMsg(), data);
    }

    public static Result<?> gone() {
        return R.error(ResultEnum.GONE.getCode(), ResultEnum.GONE.getMsg());
    }

    public static Result<?> tooManyRequests() {
        return R.error(ResultEnum.TOO_MANY_REQUESTS.getCode(), ResultEnum.TOO_MANY_REQUESTS.getMsg());
    }

    public static Result<?> paramVoid() {
        return R.error(ResultEnum.PARAM_VOID.getCode(), ResultEnum.PARAM_VOID.getMsg());
    }

    public static Result<?> paramCheckNotPass() {
        return R.error(ResultEnum.PARAM_CHECK_NOT_PASS.getCode(), ResultEnum.PARAM_CHECK_NOT_PASS.getMsg());
    }

    public static <T> Result<T> paramCheckNotPass(T data) {
        return R.error(ResultEnum.PARAM_CHECK_NOT_PASS.getCode(), ResultEnum.PARAM_CHECK_NOT_PASS.getMsg(), data);
    }

    public static Result<?> paramValueInvalid() {
        return R.error(ResultEnum.PARAM_VALUE_INVALID.getCode(), ResultEnum.PARAM_VALUE_INVALID.getMsg());
    }

    public static <T> Result<T> paramValueInvalid(T data) {
        return R.error(ResultEnum.PARAM_VALUE_INVALID.getCode(), ResultEnum.PARAM_VALUE_INVALID.getMsg(), data);
    }

    public static Result<?> paramDecryptError() {
        return R.error(ResultEnum.PARAM_DECRYPT_ERROR.getCode(), ResultEnum.PARAM_DECRYPT_ERROR.getMsg());
    }

    public static Result<?> internalServerError() {
        return R.error(ResultEnum.INTERNAL_SERVER_ERROR.getCode(), ResultEnum.INTERNAL_SERVER_ERROR.getMsg());
    }

    public static <T> Result<T> internalServerError(T data) {
        return R.error(ResultEnum.INTERNAL_SERVER_ERROR.getCode(), ResultEnum.INTERNAL_SERVER_ERROR.getMsg(), data);
    }

    public static Result<?> requestError() {
        return R.error(ResultEnum.REQUEST_ERROR.getCode(), ResultEnum.REQUEST_ERROR.getMsg());
    }

    public static <T> Result<T> requestError(T data) {
        return R.error(ResultEnum.REQUEST_ERROR.getCode(), ResultEnum.REQUEST_ERROR.getMsg(), data);
    }

    public static Result<?> dataStructure() {
        return R.error(ResultEnum.DATA_STRUCTURE.getCode(), ResultEnum.DATA_STRUCTURE.getMsg());
    }

    public static Result<?> dataStructure(int expected, int actual) {
        String data = "Incorrect result size: expected " + expected + ", actual " + actual;
        return R.error(ResultEnum.DATA_STRUCTURE.getCode(), ResultEnum.DATA_STRUCTURE.getMsg(), data);
    }

    public static Result<?> dbError() {
        return R.error(ResultEnum.DB_ERROR.getCode(), ResultEnum.DB_ERROR.getMsg());
    }

    public static <T> Result<T> dbError(T data) {
        return R.error(ResultEnum.DB_ERROR.getCode(), ResultEnum.DB_ERROR.getMsg(), data);
    }

    public static Result<?> clientFallback() {
        return R.error(ResultEnum.CLIENT_FALLBACK.getCode(), ResultEnum.CLIENT_FALLBACK.getMsg());
    }

    public static Result<?> clientFallbackError() {
        return R.error(ResultEnum.CLIENT_FALLBACK_ERROR.getCode(), ResultEnum.CLIENT_FALLBACK_ERROR.getMsg());
    }

    public static <T> Result<T> typeConvertError(T data) {
        return R.error(ResultEnum.TYPE_CONVERT_ERROR.getCode(), ResultEnum.TYPE_CONVERT_ERROR.getMsg(), data);
    }

    public static Result<?> errorPrompt(String msg) {
        return R.error(ResultEnum.ERROR_PROMPT.getCode(), msg);
    }

    public static <T> Result<T> errorPrompt(String msg, T data) {
        return R.error(ResultEnum.ERROR_PROMPT.getCode(), msg, data);
    }

    public static Result<?> getResult(Throwable e) {
        if (e == null) {
            return R.notFound();
        }
        if (e instanceof ResultException) {
            Result<?> result = ((ResultException)e).getResult();
            log.error(result.toString());
            ExceptionUtils.printException(e);
            return result;
        }
        if (e instanceof AuthorizeException) {
            ExceptionUtils.printException(e);
            return R.movedPermanently();
        }
        if (e instanceof LoginException) {
            ExceptionUtils.printException(e);
            return R.unauthorized();
        }
        if (e instanceof AttackException) {
            ExceptionUtils.printException(e);
            return R.attack(e.getMessage());
        }
        if (e instanceof ForbiddenException) {
            ExceptionUtils.printException(e);
            return R.forbidden();
        }
        if (e instanceof ApiVersionDeprecatedException) {
            ExceptionUtils.printException(e);
            return R.gone();
        }
        if (e instanceof ParamVoidException) {
            return R.paramVoid();
        }
        if (e instanceof ParamException) {
            ExceptionUtils.printException(e);
            return R.paramCheckNotPass(e.getMessage());
        }
        if (e instanceof BindException) {
            List errors = ((BindException)e).getAllErrors();
            JSONObject paramHint = new JSONObject();
            errors.forEach(error -> {
                String str = StrUtil.subAfter((CharSequence)error.getArguments()[0].toString(), (CharSequence)"[", (boolean)true);
                String key = str.substring(0, str.length() - 1);
                String msg = error.getDefaultMessage();
                paramHint.put(key, (Object)msg);
                Console.error((Object)(key + " " + msg));
            });
            return R.paramCheckNotPass(paramHint.toString());
        }
        if (e instanceof ValidateException) {
            ExceptionUtils.printException(e);
            return R.paramCheckNotPass(e.getMessage());
        }
        if (e instanceof ParamDecryptException) {
            log.error("\u3010\u89e3\u5bc6\u9519\u8bef\u3011\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a{}", (Object)e.getMessage());
            ExceptionUtils.printException(e);
            return R.paramDecryptError();
        }
        if (e instanceof DbException) {
            e.printStackTrace();
            if (((DbException)e).isShowMsg()) {
                return R.dbError(e.getMessage());
            }
            return R.dbError();
        }
        if (e instanceof ClientFallbackException) {
            ExceptionUtils.printException(e);
            return R.clientFallback();
        }
        if (e instanceof ConvertException) {
            log.error("\u3010\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38\u3011\u8f6c\u6362\u7c7b\u578b\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a{}", (Object)e.getMessage());
            ExceptionUtils.printException(e);
            return R.typeConvertError(e.getMessage());
        }
        if (e instanceof ResponseStatusException) {
            ExceptionUtils.printException(e);
            HttpStatus httpStatus = ((ResponseStatusException)e).getStatus();
            int code = httpStatus.value();
            ResultEnum resultEnum = ResultEnum.valueOf(code);
            if (resultEnum != null) {
                return R.error(resultEnum.getCode(), resultEnum.getMsg(), e.toString());
            }
        }
        e.printStackTrace();
        return R.internalServerError(e);
    }
}

