/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.config.exception;

import ai.yue.library.base.exception.ApiVersionDeprecatedException;
import ai.yue.library.base.exception.AttackException;
import ai.yue.library.base.exception.AuthorizeException;
import ai.yue.library.base.exception.ClientFallbackException;
import ai.yue.library.base.exception.DbException;
import ai.yue.library.base.exception.ForbiddenException;
import ai.yue.library.base.exception.LoginException;
import ai.yue.library.base.exception.ParamDecryptException;
import ai.yue.library.base.exception.ParamException;
import ai.yue.library.base.exception.ParamVoidException;
import ai.yue.library.base.exception.ResultException;
import ai.yue.library.base.util.ExceptionUtils;
import ai.yue.library.base.view.R;
import ai.yue.library.base.view.Result;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.exceptions.ValidateException;
import java.io.IOException;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

public abstract class AbstractExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractExceptionHandler.class);

    @PostConstruct
    private void init() {
        log.info("\u3010\u521d\u59cb\u5316\u914d\u7f6e-\u5168\u5c40\u7edf\u4e00\u5f02\u5e38\u5904\u7406\u3011\u62e6\u622a\u6240\u6709Controller\u5c42\u5f02\u5e38\uff0c\u8fd4\u56deHTTP\u8bf7\u6c42\u6700\u5916\u5c42\u5bf9\u8c61 ... \u5df2\u521d\u59cb\u5316\u5b8c\u6bd5\u3002");
    }

    @ResponseBody
    @ExceptionHandler(value={ResultException.class})
    public abstract Result<?> resultExceptionHandler(ResultException var1);

    @ResponseBody
    @ResponseStatus(code=HttpStatus.UNAUTHORIZED)
    @ExceptionHandler(value={LoginException.class})
    public Result<?> loginExceptionHandler(LoginException e) {
        ExceptionUtils.printException(e);
        return R.unauthorized();
    }

    @ResponseBody
    @ResponseStatus(code=HttpStatus.PAYMENT_REQUIRED)
    @ExceptionHandler(value={AttackException.class})
    public Result<?> attackExceptionHandler(AttackException e) {
        ExceptionUtils.printException(e);
        return R.attack(e.getMessage());
    }

    @ResponseBody
    @ResponseStatus(code=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={ForbiddenException.class})
    public Result<?> forbiddenExceptionHandler(ForbiddenException e) {
        ExceptionUtils.printException(e);
        return R.forbidden();
    }

    @ResponseBody
    @ResponseStatus(code=HttpStatus.GONE)
    @ExceptionHandler(value={ApiVersionDeprecatedException.class})
    public Result<?> apiVersionDeprecatedExceptionHandler(ApiVersionDeprecatedException e) {
        ExceptionUtils.printException(e);
        return R.gone();
    }

    @ResponseBody
    @ExceptionHandler(value={ParamVoidException.class})
    public abstract Result<?> paramVoidExceptionHandler();

    @ResponseBody
    @ExceptionHandler(value={ParamException.class})
    public abstract Result<?> paramExceptionHandler(ParamException var1);

    @ResponseBody
    @ExceptionHandler(value={BindException.class})
    public abstract Result<?> bindExceptionHandler(BindException var1);

    @ResponseBody
    @ExceptionHandler(value={ValidateException.class})
    public abstract Result<?> validateExceptionHandler(ValidateException var1);

    @ResponseBody
    @ExceptionHandler(value={ParamDecryptException.class})
    public abstract Result<?> paramDecryptExceptionHandler(ParamDecryptException var1);

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public Result<?> exceptionHandler(Exception e) {
        return R.getResult(e);
    }

    @ResponseBody
    @ResponseStatus(code=HttpStatus.VARIANT_ALSO_NEGOTIATES)
    @ExceptionHandler(value={DbException.class})
    public Result<?> dbExceptionHandler(DbException e) {
        e.printStackTrace();
        if (e.isShowMsg()) {
            return R.dbError(e.getMessage());
        }
        return R.dbError();
    }

    @ResponseBody
    @ResponseStatus(code=HttpStatus.INSUFFICIENT_STORAGE)
    @ExceptionHandler(value={ClientFallbackException.class})
    public Result<?> clientFallbackExceptionHandler(ClientFallbackException e) {
        ExceptionUtils.printException(e);
        return R.clientFallback();
    }

    @ResponseBody
    @ResponseStatus(code=HttpStatus.BANDWIDTH_LIMIT_EXCEEDED)
    @ExceptionHandler(value={ConvertException.class})
    public Result<?> convertExceptionHandler(ConvertException e) {
        log.error("\u3010\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38\u3011\u8f6c\u6362\u7c7b\u578b\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a{}", (Object)e.getMessage());
        ExceptionUtils.printException((Throwable)e);
        return R.typeConvertError(e.getMessage());
    }

    @ExceptionHandler(value={AuthorizeException.class})
    public abstract void authorizeExceptionHandler(AuthorizeException var1) throws IOException;
}

