/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.config.thread.pool;

import ai.yue.library.base.config.thread.pool.RejectedExecutionHandlerPolicy;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="yue.thread-pool.async")
public class AsyncProperties {
    public static final String SERVLET_ASYNC_CONTEXT_TIMEOUT_MILLIS = "servletAsyncContextTimeoutMillis";
    private boolean enabled = false;
    private String threadNamePrefix = "async-exec-";
    private Integer corePoolSize = 10;
    private Integer maxPoolSize = 20;
    private Integer keepAliveSeconds = 60;
    private Integer queueCapacity = 200;
    private boolean allowCoreThreadTimeOut = false;
    private boolean waitForTasksToCompleteOnShutdown = true;
    private Integer awaitTerminationSeconds = 5;
    private RejectedExecutionHandlerPolicy rejectedExecutionHandlerPolicy = RejectedExecutionHandlerPolicy.CALLER_RUNS_POLICY;
    private boolean enableServletAsyncContext = false;
    private Long servletAsyncContextTimeoutMillis = 600L;

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public Integer getCorePoolSize() {
        return this.corePoolSize;
    }

    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public Integer getKeepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public Integer getQueueCapacity() {
        return this.queueCapacity;
    }

    public boolean isAllowCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public boolean isWaitForTasksToCompleteOnShutdown() {
        return this.waitForTasksToCompleteOnShutdown;
    }

    public Integer getAwaitTerminationSeconds() {
        return this.awaitTerminationSeconds;
    }

    public RejectedExecutionHandlerPolicy getRejectedExecutionHandlerPolicy() {
        return this.rejectedExecutionHandlerPolicy;
    }

    public boolean isEnableServletAsyncContext() {
        return this.enableServletAsyncContext;
    }

    public Long getServletAsyncContextTimeoutMillis() {
        return this.servletAsyncContextTimeoutMillis;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
    }

    public void setCorePoolSize(Integer corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setKeepAliveSeconds(Integer keepAliveSeconds) {
        this.keepAliveSeconds = keepAliveSeconds;
    }

    public void setQueueCapacity(Integer queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public void setAllowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
    }

    public void setWaitForTasksToCompleteOnShutdown(boolean waitForTasksToCompleteOnShutdown) {
        this.waitForTasksToCompleteOnShutdown = waitForTasksToCompleteOnShutdown;
    }

    public void setAwaitTerminationSeconds(Integer awaitTerminationSeconds) {
        this.awaitTerminationSeconds = awaitTerminationSeconds;
    }

    public void setRejectedExecutionHandlerPolicy(RejectedExecutionHandlerPolicy rejectedExecutionHandlerPolicy) {
        this.rejectedExecutionHandlerPolicy = rejectedExecutionHandlerPolicy;
    }

    public void setEnableServletAsyncContext(boolean enableServletAsyncContext) {
        this.enableServletAsyncContext = enableServletAsyncContext;
    }

    public void setServletAsyncContextTimeoutMillis(Long servletAsyncContextTimeoutMillis) {
        this.servletAsyncContextTimeoutMillis = servletAsyncContextTimeoutMillis;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncProperties)) {
            return false;
        }
        AsyncProperties other = (AsyncProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isAllowCoreThreadTimeOut() != other.isAllowCoreThreadTimeOut()) {
            return false;
        }
        if (this.isWaitForTasksToCompleteOnShutdown() != other.isWaitForTasksToCompleteOnShutdown()) {
            return false;
        }
        if (this.isEnableServletAsyncContext() != other.isEnableServletAsyncContext()) {
            return false;
        }
        Integer this$corePoolSize = this.getCorePoolSize();
        Integer other$corePoolSize = other.getCorePoolSize();
        if (this$corePoolSize == null ? other$corePoolSize != null : !((Object)this$corePoolSize).equals(other$corePoolSize)) {
            return false;
        }
        Integer this$maxPoolSize = this.getMaxPoolSize();
        Integer other$maxPoolSize = other.getMaxPoolSize();
        if (this$maxPoolSize == null ? other$maxPoolSize != null : !((Object)this$maxPoolSize).equals(other$maxPoolSize)) {
            return false;
        }
        Integer this$keepAliveSeconds = this.getKeepAliveSeconds();
        Integer other$keepAliveSeconds = other.getKeepAliveSeconds();
        if (this$keepAliveSeconds == null ? other$keepAliveSeconds != null : !((Object)this$keepAliveSeconds).equals(other$keepAliveSeconds)) {
            return false;
        }
        Integer this$queueCapacity = this.getQueueCapacity();
        Integer other$queueCapacity = other.getQueueCapacity();
        if (this$queueCapacity == null ? other$queueCapacity != null : !((Object)this$queueCapacity).equals(other$queueCapacity)) {
            return false;
        }
        Integer this$awaitTerminationSeconds = this.getAwaitTerminationSeconds();
        Integer other$awaitTerminationSeconds = other.getAwaitTerminationSeconds();
        if (this$awaitTerminationSeconds == null ? other$awaitTerminationSeconds != null : !((Object)this$awaitTerminationSeconds).equals(other$awaitTerminationSeconds)) {
            return false;
        }
        Long this$servletAsyncContextTimeoutMillis = this.getServletAsyncContextTimeoutMillis();
        Long other$servletAsyncContextTimeoutMillis = other.getServletAsyncContextTimeoutMillis();
        if (this$servletAsyncContextTimeoutMillis == null ? other$servletAsyncContextTimeoutMillis != null : !((Object)this$servletAsyncContextTimeoutMillis).equals(other$servletAsyncContextTimeoutMillis)) {
            return false;
        }
        String this$threadNamePrefix = this.getThreadNamePrefix();
        String other$threadNamePrefix = other.getThreadNamePrefix();
        if (this$threadNamePrefix == null ? other$threadNamePrefix != null : !this$threadNamePrefix.equals(other$threadNamePrefix)) {
            return false;
        }
        RejectedExecutionHandlerPolicy this$rejectedExecutionHandlerPolicy = this.getRejectedExecutionHandlerPolicy();
        RejectedExecutionHandlerPolicy other$rejectedExecutionHandlerPolicy = other.getRejectedExecutionHandlerPolicy();
        return !(this$rejectedExecutionHandlerPolicy == null ? other$rejectedExecutionHandlerPolicy != null : !((Object)((Object)this$rejectedExecutionHandlerPolicy)).equals((Object)other$rejectedExecutionHandlerPolicy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AsyncProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isAllowCoreThreadTimeOut() ? 79 : 97);
        result = result * 59 + (this.isWaitForTasksToCompleteOnShutdown() ? 79 : 97);
        result = result * 59 + (this.isEnableServletAsyncContext() ? 79 : 97);
        Integer $corePoolSize = this.getCorePoolSize();
        result = result * 59 + ($corePoolSize == null ? 43 : ((Object)$corePoolSize).hashCode());
        Integer $maxPoolSize = this.getMaxPoolSize();
        result = result * 59 + ($maxPoolSize == null ? 43 : ((Object)$maxPoolSize).hashCode());
        Integer $keepAliveSeconds = this.getKeepAliveSeconds();
        result = result * 59 + ($keepAliveSeconds == null ? 43 : ((Object)$keepAliveSeconds).hashCode());
        Integer $queueCapacity = this.getQueueCapacity();
        result = result * 59 + ($queueCapacity == null ? 43 : ((Object)$queueCapacity).hashCode());
        Integer $awaitTerminationSeconds = this.getAwaitTerminationSeconds();
        result = result * 59 + ($awaitTerminationSeconds == null ? 43 : ((Object)$awaitTerminationSeconds).hashCode());
        Long $servletAsyncContextTimeoutMillis = this.getServletAsyncContextTimeoutMillis();
        result = result * 59 + ($servletAsyncContextTimeoutMillis == null ? 43 : ((Object)$servletAsyncContextTimeoutMillis).hashCode());
        String $threadNamePrefix = this.getThreadNamePrefix();
        result = result * 59 + ($threadNamePrefix == null ? 43 : $threadNamePrefix.hashCode());
        RejectedExecutionHandlerPolicy $rejectedExecutionHandlerPolicy = this.getRejectedExecutionHandlerPolicy();
        result = result * 59 + ($rejectedExecutionHandlerPolicy == null ? 43 : ((Object)((Object)$rejectedExecutionHandlerPolicy)).hashCode());
        return result;
    }

    public String toString() {
        return "AsyncProperties(enabled=" + this.isEnabled() + ", threadNamePrefix=" + this.getThreadNamePrefix() + ", corePoolSize=" + this.getCorePoolSize() + ", maxPoolSize=" + this.getMaxPoolSize() + ", keepAliveSeconds=" + this.getKeepAliveSeconds() + ", queueCapacity=" + this.getQueueCapacity() + ", allowCoreThreadTimeOut=" + this.isAllowCoreThreadTimeOut() + ", waitForTasksToCompleteOnShutdown=" + this.isWaitForTasksToCompleteOnShutdown() + ", awaitTerminationSeconds=" + this.getAwaitTerminationSeconds() + ", rejectedExecutionHandlerPolicy=" + (Object)((Object)this.getRejectedExecutionHandlerPolicy()) + ", enableServletAsyncContext=" + this.isEnableServletAsyncContext() + ", servletAsyncContextTimeoutMillis=" + this.getServletAsyncContextTimeoutMillis() + ")";
    }
}

