/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.config;

import ai.yue.library.base.annotation.api.version.ApiVersionProperties;
import ai.yue.library.base.config.datetime.DateTimeFormatConfig;
import ai.yue.library.base.config.exception.ExceptionHandlerProperties;
import ai.yue.library.base.config.net.http.RestProperties;
import ai.yue.library.base.config.net.http.SkipSslVerificationHttpRequestFactory;
import ai.yue.library.base.config.net.proxy.NetProxy;
import ai.yue.library.base.config.properties.CorsProperties;
import ai.yue.library.base.config.thread.pool.AsyncConfig;
import ai.yue.library.base.util.ApplicationContextUtils;
import ai.yue.library.base.util.SpringUtils;
import ai.yue.library.base.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
@Import(value={ApplicationContextUtils.class, SpringUtils.class, NetProxy.class, AsyncConfig.class, DateTimeFormatConfig.class})
@EnableConfigurationProperties(value={ApiVersionProperties.class, ExceptionHandlerProperties.class, RestProperties.class, CorsProperties.class})
public class BaseAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(BaseAutoConfig.class);

    @Bean
    @ConditionalOnMissingBean
    public RestTemplate restTemplate(RestProperties restProperties) {
        Integer readTimeout;
        SkipSslVerificationHttpRequestFactory factory = new SkipSslVerificationHttpRequestFactory();
        Integer connectTimeout = restProperties.getConnectTimeout();
        if (connectTimeout != null) {
            factory.setConnectTimeout(connectTimeout);
        }
        if ((readTimeout = restProperties.getReadTimeout()) != null) {
            factory.setReadTimeout(readTimeout);
        }
        log.info("\u3010\u521d\u59cb\u5316\u914d\u7f6e-HTTPS\u5ba2\u6237\u7aef\u3011Bean\uff1aRestTemplate ... \u5df2\u521d\u59cb\u5316\u5b8c\u6bd5\u3002");
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @Bean
    @ConditionalOnMissingBean
    public Validator validator() {
        log.info("\u3010\u521d\u59cb\u5316\u914d\u7f6e-\u6821\u9a8c\u5668\u3011Bean\uff1aValidator ... \u5df2\u521d\u59cb\u5316\u5b8c\u6bd5\u3002");
        return new Validator();
    }
}

